/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.monitor;

import com.humuson.tms.monitor.Observer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum NotificationContext {
    PushSendCountSnapshot,
    SmtpSendCountSnapshot,
    DSMonitorObserver,
    CTMonitorObserver,
    MPMonitorObserver,
    SDMonitorObserver,
    MNMonitorObserver;

    private static final Logger log;
    private List<Observer> observers = new ArrayList<Observer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void add(Observer<T> o) {
        NotificationContext notificationContext = this;
        synchronized (notificationContext) {
            this.observers.add(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void remove(Observer<T> o) {
        NotificationContext notificationContext = this;
        synchronized (notificationContext) {
            int i = this.observers.indexOf(o);
            if (i >= 0) {
                this.observers.remove(i);
            }
        }
    }

    public <T> void notifyStatus(T t) {
        for (Observer observer : this.observers) {
            try {
                observer.update(t);
            }
            catch (Exception e) {
                log.error("Observer[{}] notify error continue..  \n Exception {} ", (Object)observer, (Object)e);
            }
        }
    }

    public List<Observer> value() {
        return this.observers;
    }

    static {
        log = LoggerFactory.getLogger(NotificationContext.class);
    }
}

