/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.monitor;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.ArrayList;
import java.util.Collection;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;

public class MemoryWarningSystem {
    private final Collection<Listener> listeners = new ArrayList<Listener>();
    private static final MemoryPoolMXBean tenuredGenPool = MemoryWarningSystem.findTenuredGenPool();

    public MemoryWarningSystem() {
        MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
        NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
        emitter.addNotificationListener(new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object hb) {
                if (notification.getType().equals("java.management.memory.threshold.exceeded")) {
                    long maxMemory = tenuredGenPool.getUsage().getMax();
                    long usedMemory = tenuredGenPool.getUsage().getUsed();
                    for (Listener listener : MemoryWarningSystem.this.listeners) {
                        listener.memoryUsageLow(usedMemory, maxMemory);
                    }
                }
            }
        }, null, null);
    }

    public boolean addListener(Listener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(Listener listener) {
        return this.listeners.remove(listener);
    }

    public void setPercentageUsageThreshold(double percentage) {
        if (percentage <= 0.0 || percentage > 1.0) {
            throw new IllegalArgumentException("Percentage not in range");
        }
        long maxMemory = tenuredGenPool.getUsage().getMax();
        long warningThreshold = (long)((double)maxMemory * percentage);
        tenuredGenPool.setUsageThreshold(warningThreshold);
    }

    public static MemoryPoolMXBean findTenuredGenPool() {
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (pool.getType() != MemoryType.HEAP || !pool.isUsageThresholdSupported()) continue;
            return pool;
        }
        throw new IllegalStateException("Could not find tenured space");
    }

    public static void main(String[] args) throws Exception {
        MemoryWarningSystem system = new MemoryWarningSystem();
        system.setPercentageUsageThreshold(0.1);
        new Thread(){

            @Override
            public void run() {
                StringBuilder sb = new StringBuilder();
                String text = "asdjf;ajsfdk;asdkf;jasdjfkasjdkfj;asdjf;kja;sldjf;kj";
                for (int i = 0; i < 10000000; ++i) {
                    sb.append(text);
                    System.out.println(sb.toString());
                    try {
                        Thread.sleep(500L);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }.start();
        System.out.println("wait system ");
        Thread.sleep(2000L);
        System.out.println("start listener system ");
        system.addListener(new Listener(){

            @Override
            public void memoryUsageLow(long usedMemory, long maxMemory) {
                System.out.println("low: " + usedMemory + " / " + maxMemory);
            }
        });
        MemoryPoolMXBean mxBean = system.findTenuredGenPool();
        while (true) {
            long maxMemory = mxBean.getUsage().getMax();
            long usedMemory = mxBean.getUsage().getUsed();
            System.out.println("max memory=" + maxMemory + "| used memory=" + usedMemory);
            Thread.sleep(1000L);
        }
    }

    public static interface Listener {
        public void memoryUsageLow(long var1, long var3);
    }
}

