/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.monitor;

import com.humuson.tms.util.chunk.LimitTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLimitTimer<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractLimitTimer.class);
    private LimitTimer limitTimer = null;

    protected void tryExecute(T t) {
        if (this.limitTimer == null) {
            try {
                this.timeOverExecute(t);
            }
            catch (Exception e) {
                log.error("try first execute error", (Throwable)e);
            }
            this.limitTimer = new LimitTimer(this.limitSecTime());
        } else if (this.limitTimer.limitOver()) {
            this.limitTimer.initTerm();
            try {
                this.timeOverExecute(t);
            }
            catch (Exception e) {
                log.error("try execute error", (Throwable)e);
            }
        } else {
            log.warn("this system is dangerous condition - skip..");
        }
    }

    public abstract void timeOverExecute(T var1) throws Exception;

    protected abstract int limitSecTime();
}

