/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.crypto;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLChecker {
    public static final String PRODUCTION = "Apple Push Services|Apple Production IOS Push Services";
    public static final String DEVELOPMENT = "Apple Development IOS Push Services";
    private static final Logger logger = LoggerFactory.getLogger(SSLChecker.class);

    public static boolean isValidPassword(String keystore, String password) {
        FileInputStream certStream = null;
        try {
            certStream = new FileInputStream(keystore);
            return SSLChecker.isValidPassword(certStream, password);
        }
        catch (Exception e1) {
            logger.error("isValidPassword error", (Throwable)e1);
            return false;
        }
    }

    public static boolean isValidPassword(InputStream certStream, String password) {
        try {
            KeyStore p12 = KeyStore.getInstance("pkcs12");
            logger.info("password :{}", (Object)password);
            p12.load(certStream, password.toCharArray());
            return true;
        }
        catch (CertificateException e) {
            logger.error("password check failed", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("isValidPassword error", (Throwable)e);
        }
        return false;
    }

    public static boolean isProduction(InputStream certStream, String password) {
        return SSLChecker.isProduction(certStream, password, PRODUCTION, DEVELOPMENT, true);
    }

    public static boolean isProduction(InputStream certStream, String password, boolean isWeb) {
        return SSLChecker.isProduction(certStream, password, PRODUCTION, DEVELOPMENT, isWeb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isProduction(InputStream certStream, String password, String productionCN, String developmentCN, boolean isWeb) {
        boolean isProductionCert = false;
        KeyStore keystore = null;
        try {
            keystore = KeyStore.getInstance("PKCS12");
            keystore.load(certStream, password.toCharArray());
            Enumeration<String> aliases = keystore.aliases();
            if (aliases.hasMoreElements()) {
                X509Certificate certificate = (X509Certificate)keystore.getCertificate(aliases.nextElement());
                String cnName = SSLChecker.findCnName(certificate);
                for (String cn : productionCN.split("\\|")) {
                    if (cnName.indexOf(cn) <= -1) continue;
                    isProductionCert = true;
                }
                for (String cn : developmentCN.split("\\|")) {
                    if (cnName.indexOf(cn) <= -1) continue;
                    isProductionCert = false;
                }
            }
        }
        catch (Exception e) {
            logger.error("p12ProductionCheck error", (Throwable)e);
        }
        finally {
            try {
                if (certStream != null && !isWeb) {
                    certStream.close();
                }
            }
            catch (IOException e) {
                logger.error("p12ProductionCheck error", (Throwable)e);
            }
        }
        return isProductionCert;
    }

    public static boolean isProduction(String keystore, String password) {
        FileInputStream certStream = null;
        try {
            certStream = new FileInputStream(keystore);
            return SSLChecker.isProduction(certStream, password);
        }
        catch (Exception e1) {
            logger.error("isProduction error", (Throwable)e1);
            return false;
        }
    }

    public static String getExpireDate(String keystore, String password) {
        FileInputStream certStream = null;
        try {
            certStream = new FileInputStream(keystore);
            return SSLChecker.getExpireDate(certStream, password);
        }
        catch (Exception e1) {
            logger.error("getExpireDate error", (Throwable)e1);
            return null;
        }
    }

    public static String getExpireDate(InputStream certStream, String password) {
        String expireDate = null;
        try {
            KeyStore p12 = KeyStore.getInstance("pkcs12");
            logger.info("password :{}", (Object)password);
            p12.load(certStream, password.toCharArray());
            Enumeration<String> e = p12.aliases();
            if (e.hasMoreElements()) {
                String alias = e.nextElement();
                X509Certificate c = (X509Certificate)p12.getCertificate(alias);
                expireDate = new SimpleDateFormat("yyyyMMddHHmmss").format(c.getNotAfter());
            }
        }
        catch (Exception e1) {
            logger.error("getExpireDate error", (Throwable)e1);
        }
        logger.info("expireDate  :{}", expireDate);
        return expireDate;
    }

    public static boolean checkValidity(InputStream certStream, String password) {
        boolean isExpired = true;
        try {
            KeyStore p12 = KeyStore.getInstance("pkcs12");
            p12.load(certStream, password.toCharArray());
            Enumeration<String> e = p12.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                X509Certificate c = (X509Certificate)p12.getCertificate(alias);
                c.checkValidity(new Date());
            }
        }
        catch (Exception e1) {
            logger.error("checkValidity error", (Throwable)e1);
            isExpired = false;
        }
        return isExpired;
    }

    public static boolean checkValidity(String keystore, String password) {
        FileInputStream certStream = null;
        try {
            certStream = new FileInputStream(keystore);
            return SSLChecker.checkValidity(certStream, password);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected static String findCnName(X509Certificate certificate) throws InvalidNameException {
        LdapName ldapDN = new LdapName(certificate.getSubjectX500Principal().getName());
        String cnName = null;
        for (Rdn rdn : ldapDN.getRdns()) {
            if (!rdn.getType().equals("CN")) continue;
            cnName = String.valueOf(rdn.getValue());
            break;
        }
        return cnName;
    }

    public static void main(String[] args) {
        String cert = "/Users/hyogun/workspace/pms-work/pms-commons-trunk/apns_apns-gsshop-prd.p12";
        if (SSLChecker.isValidPassword(cert, "gs13253")) {
            String expireDate = SSLChecker.getExpireDate(cert, "gs13253");
            logger.info(expireDate);
            boolean isValid = SSLChecker.checkValidity(cert, "gs13253");
            logger.info("isValid : {}", (Object)isValid);
            boolean isProduction = SSLChecker.isProduction(cert, "gs13253");
            logger.info("production p12 {}", (Object)isProduction);
        } else {
            logger.info("password invalid");
        }
    }
}

