/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.crypto;

import com.humuson.tms.crypto.HumusonZip;
import com.humuson.tms.crypto.Seed;
import java.util.Map;
import org.apache.xmlbeans.impl.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HumusonEncryptor {
    private static final Logger logger = LoggerFactory.getLogger(HumusonEncryptor.class);
    private static String FREEKEY = "Pg-s_E_n_C_k_e_y";

    public static String generateKey(String key) {
        String genKey = null;
        genKey = key == null ? FREEKEY.substring(0, 16) : (key.length() > 16 ? key.substring(0, 16) : key + FREEKEY.substring(0, 16 - key.length()));
        return genKey;
    }

    public static String encrypt(String str) {
        return HumusonEncryptor.encrypt(str, FREEKEY, "UTF-8");
    }

    public static String encrypt(String str, String userKey) {
        return HumusonEncryptor.encrypt(str, userKey, "UTF-8", true);
    }

    public static <K, V> void encrypt(Map<K, V> map, Map<K, V> tmp, String userKey) {
        for (K key : map.keySet()) {
            if (key instanceof String && map.get(key) instanceof String) {
                tmp.put(key, HumusonEncryptor.encrypt(map.get(key).toString(), userKey, "UTF-8", true));
                continue;
            }
            tmp.put(key, (String)map.get(key));
        }
    }

    public static String encrypt(String str, String userKey, boolean useZip) {
        return HumusonEncryptor.encrypt(str, userKey, "UTF-8", useZip);
    }

    public static String encrypt(String str, String userKey, String charSet) {
        return HumusonEncryptor.encrypt(str, userKey, "UTF-8", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encrypt(String str, String userKey, String charSet, boolean useZip) {
        String returnStr = "";
        if (str == null || userKey == null || charSet == null) {
            return returnStr;
        }
        userKey = userKey.length() < 16 ? HumusonEncryptor.generateKey(userKey) : userKey.substring(0, 16);
        try {
            byte[] enc2 = null;
            if (useZip) {
                byte[] enc1 = HumusonZip.zipStringToBytes(str, charSet);
                enc2 = Seed.seedEncrypt(enc1, userKey.getBytes());
            } else {
                enc2 = Seed.seedEncrypt(str.getBytes(), userKey.getBytes());
            }
            returnStr = new String(Base64.encode((byte[])enc2), charSet);
        }
        catch (Exception e) {
            try {
                logger.error("encrypt error :return value=[{}] input param[input param:{}]", new Object[]{returnStr, str, e});
            }
            catch (Throwable throwable) {
                if (logger.isDebugEnabled()) {
                    logger.debug("encrypt :{} params[str:{}, userKey:{}, useZip:{}]", new Object[]{returnStr, str, userKey, useZip});
                }
                throw throwable;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("encrypt :{} params[str:{}, userKey:{}, useZip:{}]", new Object[]{returnStr, str, userKey, useZip});
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("encrypt :{} params[str:{}, userKey:{}, useZip:{}]", new Object[]{returnStr, str, userKey, useZip});
        }
        return returnStr;
    }

    public static void main(String[] args) {
        HumusonEncryptor humusonEncryptor = new HumusonEncryptor();
        String pmsIdEncKey = "humuson0722^^_^^";
        String data = "humuson123!";
        String encStr = HumusonEncryptor.encrypt(data);
        System.out.println("Key \uc554\ud638\ud654 :" + encStr);
        HumusonEncryptor.encrypt("humuson|211.48.18.131|9999");
        HumusonEncryptor.encrypt("humuson|192.168.0.10|9999");
        HumusonEncryptor.encrypt("humuson|192.168.0.10|20180808");
        System.out.println("-------------------");
        HumusonEncryptor.encrypt("humuson|211.48.18.51|9999");
        System.out.println("-------------------");
        HumusonEncryptor.encrypt("humuson|211.48.18.52|9999");
    }
}

