/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.crypto;

import com.humuson.tms.crypto.HumusonZip;
import com.humuson.tms.crypto.Seed;
import java.util.Map;
import org.apache.xmlbeans.impl.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HumusonDecryptor {
    private static final Logger logger = LoggerFactory.getLogger(HumusonDecryptor.class);
    public static String FREEKEY = "Pg-s_E_n_C_k_e_y";

    public static String generateKey(String key) {
        String genKey = null;
        genKey = key == null ? FREEKEY.substring(0, 16) : (key.length() > 16 ? key.substring(0, 16) : key + FREEKEY.substring(0, 16 - key.length()));
        return genKey;
    }

    public static String decrypt(boolean isErrorReturnOrg, String str, String userKey) throws Exception {
        try {
            return HumusonDecryptor.decrypt(str, userKey, true);
        }
        catch (Exception e) {
            if (isErrorReturnOrg) {
                return str;
            }
            throw e;
        }
    }

    public static String generateKey(String key, String freeKey) {
        String genKey = null;
        genKey = key == null ? freeKey.substring(0, 16) : (key.length() > 16 ? key.substring(0, 16) : key + freeKey.substring(0, 16 - key.length()));
        return genKey;
    }

    public static String decrypt(String str) throws Exception {
        return HumusonDecryptor.decrypt(str, FREEKEY);
    }

    public static String decrypt(String str, String userKey) throws Exception {
        return HumusonDecryptor.decrypt(str, userKey, true);
    }

    public static <K, V> void decrypt(Map<K, V> map, Map<K, V> tmp, String userKey) throws Exception {
        for (K key : map.keySet()) {
            if (key instanceof String && map.get(key) instanceof String) {
                tmp.put(key, HumusonDecryptor.decrypt(map.get(key).toString(), userKey, true));
                continue;
            }
            tmp.put(key, (String)map.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decrypt(String str, String userKey, boolean useZip) throws Exception {
        if (str == null) {
            return null;
        }
        String returnStr = "";
        try {
            byte[] dec2;
            userKey = userKey.length() < 16 ? HumusonDecryptor.generateKey(userKey) : userKey.substring(0, 16);
            byte[] byArray = dec2 = userKey == null ? Seed.seedDecrypt(Base64.decode((byte[])str.getBytes())) : Seed.seedDecrypt(Base64.decode((byte[])str.getBytes()), userKey.getBytes());
            if (useZip) {
                returnStr = HumusonZip.unzipStringFromBytes(dec2);
            } else {
                int i;
                for (i = 0; i < dec2.length && dec2[i] != 0; ++i) {
                }
                returnStr = new String(dec2, 0, i);
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("decrypt error :return value=[{}] input param[input param:{}]", (Object)returnStr, (Object)str);
            }
            String string = str;
            return string;
        }
        return returnStr;
    }

    public static void main(String[] args) {
        try {
            String str = HumusonDecryptor.decrypt("YJSDGCi46Tr73NPgHcI7InfCZEalC6CG3kVMXg9tHDBvatu0N4pIoXJ0s7UiX7lg");
            System.out.println(str);
            str = HumusonDecryptor.decrypt("YJSDGCi46Tr73NPgHcI7IpNcjrstNgYlZDDoqq0I6qr9GNUbVdmHX0d1bF5IYybl");
            System.out.println(str);
            str = HumusonDecryptor.decrypt("YJSDGCi46Tr73NPgHcI7Itm7xrI0OrqmbgSDkxHyAtDnswG8jNO9Y616r+S/Xf63");
            System.out.println(str);
            str = HumusonDecryptor.decrypt("YJSDGCi46Tr73NPgHcI7Itm7xrI0OrqmbgSDkxHyAtCUrKjcOcAWjUAN4rfYOGO7/lhrpqIrtbQL6D1pBqJgig==");
            System.out.println(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

