/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.config.lock;

import com.humuson.tms.adaptor.redis.RedissonAutoConfiguration;
import com.humuson.tms.config.lock.LockController;
import com.humuson.tms.util.seq.TimeUtil;
import org.redisson.RedissonRedLock;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.core.RedisOperations;
import redis.clients.jedis.Jedis;

@Configuration
@ConditionalOnClass(value={JedisConnection.class, RedisOperations.class, Jedis.class})
@EnableConfigurationProperties(value={RedisProperties.class})
public class LockContexter {
    private static final Logger log = LoggerFactory.getLogger(LockContexter.class);
    private boolean closeWhenUnlock = false;
    @Value(value="${spring.redis.sentinel.nodes}")
    private String addresses;

    public LockController localLock(String node) {
        if (log.isInfoEnabled()) {
            log.info("local lock return node name={}", (Object)node);
        }
        RedisLockHandler redisLockHandler = this.redisLockHandler();
        redisLockHandler.setNode(node);
        return redisLockHandler;
    }

    public LockController lock(String node) {
        if (log.isDebugEnabled()) {
            log.debug("distribute lock return node name={}", (Object)node);
        }
        RedisLockHandler redisLockHandler = this.redisLockHandler();
        redisLockHandler.setNode(node);
        return redisLockHandler;
    }

    @Bean
    @Scope(value="prototype")
    @DependsOn(value={"redissonAutoConfiguration", "sentinelRedisConfig"})
    public RedisLockHandler redisLockHandler() {
        return new RedisLockHandler();
    }

    public class Mutex
    implements LockController {
        private boolean lock = false;
        private final String node;

        private Mutex(String node) {
            this.node = node;
        }

        @Override
        public synchronized void unLock() {
            try {
                this.lock = false;
                this.notifyAll();
            }
            catch (Exception e) {
                log.error("error local[{}] unlock ", (Object)this.node, (Object)e);
            }
            finally {
                if (LockContexter.this.closeWhenUnlock) {
                    this.close();
                }
            }
        }

        @Override
        public synchronized void lock() {
            try {
                while (this.lock) {
                    this.wait();
                }
                this.lock = true;
            }
            catch (Exception e) {
                log.error("mutex trying lock[{}] error ", (Object)this.node, (Object)e);
                this.lock();
            }
        }

        @Override
        public void close() {
            log.info("removing mutex lock name[{}]", (Object)this.node);
        }

        @Override
        public boolean status() {
            return this.lock;
        }

        @Override
        public boolean isLocked() {
            return this.lock;
        }
    }

    class RedisLockHandler
    implements LockController {
        private String node;
        @Autowired
        RedissonAutoConfiguration redissonAutoConfiguration;
        @Autowired
        private LockContexter contexter;
        @Autowired
        private RedissonClient redissonClient;
        private RedissonRedLock lock;
        private RLock rLock;

        RedisLockHandler() {
        }

        public void setNode(String node) {
            String nodeName = node;
            if (this.redissonClient == null) {
                this.redissonClient = this.redissonAutoConfiguration.redissonClient();
            } else {
                this.rLock = this.redissonClient.getLock(nodeName);
            }
            this.lock = new RedissonRedLock(new RLock[]{this.rLock});
            this.node = node;
        }

        @Override
        public boolean status() {
            if (this.rLock.isExists()) {
                return this.rLock.isLocked();
            }
            return false;
        }

        public void init() {
            if (this.redissonClient != null) {
                this.redissonClient.shutdown();
            }
            try {
                this.redissonClient = this.redissonAutoConfiguration.redissonClient();
            }
            catch (Exception e) {
                log.error("[se] lock node[{}] redisson client init error retry..", (Object)this.node, (Object)e);
                TimeUtil.mileSecondsLockSleep(1000);
                this.init();
            }
        }

        @Override
        public void lock() {
            try {
                this.lock.lock();
            }
            catch (Exception e) {
                log.error("distribute lock[{}] error", (Object)this.node, (Object)e);
            }
        }

        @Override
        public void unLock() {
            try {
                this.lock.unlock();
            }
            catch (Exception e) {
                log.error("distribute un lock[{}] error", (Object)this.node, (Object)e);
            }
        }

        @Override
        public void close() {
            this.unLock();
        }

        @Override
        public boolean isLocked() {
            return this.status();
        }
    }
}

