/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.config.lock;

import com.humuson.tms.config.TmsCommonConfig;
import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.config.lock.LockController;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class DuplicationRunMonitor {
    private static final Logger log = LoggerFactory.getLogger(DuplicationRunMonitor.class);
    private String engineNode;
    @Autowired
    TmsCommonConfig tmsConfig;
    @Lazy
    @Autowired(required=false)
    private LockContexter contexter;

    @PostConstruct
    public void duplicationRunChecker() {
        if (ObjectUtils.isEmpty((Object)this.contexter)) {
            return;
        }
        this.engineNode = this.tmsConfig.getEngine() + this.tmsConfig.getNode();
        LockController lock = null;
        log.info("TMS checking alive engine[{}]", (Object)this.engineNode);
        try {
            lock = this.contexter.lock(this.engineNode);
            if (this.isDemonAlive(lock)) {
                log.warn("make sure it's engine[{}] already activated. this engine close.", (Object)this.engineNode);
                System.exit(-1);
            }
            lock.lock();
        }
        catch (Exception e) {
            log.error("make sure it's engine[{}] error. this engine & redis need confirmation .", (Object)this.engineNode, (Object)e);
            System.exit(-1);
        }
    }

    private boolean isDemonAlive(LockController lock) {
        if (lock.isLocked()) {
            return true;
        }
        try {
            Thread.sleep(2000L);
            return lock.isLocked();
        }
        catch (InterruptedException e) {
            log.error("Thread sleep interupted exception ", (Throwable)e);
        }
        catch (Exception e1) {
            log.error("lock error", (Throwable)e1);
        }
        return false;
    }
}

