/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.config.lock;

import com.humuson.tms.config.TmsCommonConfig;
import com.humuson.tms.config.lock.AllLockController;
import com.humuson.tms.config.lock.DistributeLock;
import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.config.lock.LockController;
import java.lang.reflect.Method;
import javax.annotation.PostConstruct;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DistributeLockIntercepter {
    private static final Logger log = LoggerFactory.getLogger(DistributeLockIntercepter.class);
    @Autowired(required=false)
    private LockContexter lockContexter;
    @Autowired
    private TmsCommonConfig tmsConfig;
    private static String DEMON_NAME = "";

    @PostConstruct
    public void init() {
        DEMON_NAME = this.tmsConfig.getEngine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Around(value="@annotation(com.humuson.tms.config.lock.DistributeLock)")
    public void around(ProceedingJoinPoint joinPoint) {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        DistributeLock distributeLockAnnotation = method.getAnnotation(DistributeLock.class);
        String distributeLockName = distributeLockAnnotation.value();
        String lockNameAndDemonName = this.resolvePropertyValue(distributeLockName);
        if (AllLockController.SCHDULER.isAllLock()) {
            if (AllLockController.SCHDULER.isClear()) {
                log.warn("all schedule locked. so this method[{}] is skip", (Object)method.getName());
                return;
            }
            if (!AllLockController.SCHDULER.isLock(method.getName())) {
                log.info("this method[{}] un locked", (Object)method.getName());
            } else {
                log.warn("all schedule locked. so this method[{}] is skip", (Object)method.getName());
                return;
            }
        }
        if (!AllLockController.SCHDULER.isAllLock() && !AllLockController.SCHDULER.isClear() && AllLockController.SCHDULER.isLock(method.getName())) {
            log.warn("try lock from web call. this method[{}] is skip", (Object)method.getName());
            return;
        }
        if (distributeLockAnnotation == null) {
            log.error("distribute lock[{}] annotation is null. so return", (Object)lockNameAndDemonName);
            return;
        }
        LockController lock = this.lockContexter.lock(lockNameAndDemonName);
        boolean last = false;
        try {
            if (lock.isLocked()) {
                if (!log.isInfoEnabled()) return;
                log.info("[LOCK] {} is already locking. this method[{}] is skip", (Object)lockNameAndDemonName, (Object)method.getName());
                return;
            }
            if (AllLockController.SCHDULER.isMonitor(method.getName(), distributeLockName)) {
                log.info("[LOCKED={}] run method[{}]", (Object)lockNameAndDemonName, (Object)method.getName());
                last = true;
            }
            lock.lock();
            joinPoint.proceed();
            return;
        }
        catch (Exception e) {
            log.error("this method[{}] running error", (Object)method.getName(), (Object)e);
            return;
        }
        catch (Throwable e) {
            log.error("this method[{}] running error", (Object)method.getName(), (Object)e);
            return;
        }
        finally {
            try {
                lock.unLock();
                if (!last) return;
                log.info("[UNLOCKED={}] end method[{}]", (Object)lockNameAndDemonName, (Object)method.getName());
                return;
            }
            catch (Exception e2) {
                log.error("lock[{}] unlock try error. so one more retry", (Object)lockNameAndDemonName, (Object)e2);
                lock.unLock();
            }
        }
    }

    private String resolvePropertyValue(String value) {
        return value + "-" + DEMON_NAME;
    }
}

