/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.config;

import com.humuson.tms.crypto.HumusonDecryptor;
import java.util.Arrays;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class TmsCommonConfig {
    private static final Logger log = LoggerFactory.getLogger(TmsCommonConfig.class);
    @Value(value="${tms.company}")
    private String company;
    @Value(value="${tms.daemon-type}")
    private String engine;
    @Value(value="${tms.daemon-id}")
    private String node;
    @Value(value="${tms.monitor.watcher.url}")
    private String[] watcherUrls;
    @Value(value="${tms.security.encrypt-key}")
    private String key;
    @Value(value="${tms.fix-channel.channel:ALL}")
    String fixedChannels;
    private String humusonKey;

    @PostConstruct
    public void init() {
        try {
            this.humusonKey = HumusonDecryptor.decrypt(this.key);
        }
        catch (Exception e) {
            log.error("humuson decrypt error so orginal key return", (Throwable)e);
            this.humusonKey = this.key;
        }
    }

    public String getCompany() {
        return this.company;
    }

    public String getEngine() {
        return this.engine;
    }

    public String getNode() {
        return this.node;
    }

    public String[] getWatcherUrls() {
        return this.watcherUrls;
    }

    public String getKey() {
        return this.key;
    }

    public String getFixedChannels() {
        return this.fixedChannels;
    }

    public String getHumusonKey() {
        return this.humusonKey;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public void setWatcherUrls(String[] watcherUrls) {
        this.watcherUrls = watcherUrls;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setFixedChannels(String fixedChannels) {
        this.fixedChannels = fixedChannels;
    }

    public void setHumusonKey(String humusonKey) {
        this.humusonKey = humusonKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TmsCommonConfig)) {
            return false;
        }
        TmsCommonConfig other = (TmsCommonConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$company = this.getCompany();
        String other$company = other.getCompany();
        if (this$company == null ? other$company != null : !this$company.equals(other$company)) {
            return false;
        }
        String this$engine = this.getEngine();
        String other$engine = other.getEngine();
        if (this$engine == null ? other$engine != null : !this$engine.equals(other$engine)) {
            return false;
        }
        String this$node = this.getNode();
        String other$node = other.getNode();
        if (this$node == null ? other$node != null : !this$node.equals(other$node)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getWatcherUrls(), other.getWatcherUrls())) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$fixedChannels = this.getFixedChannels();
        String other$fixedChannels = other.getFixedChannels();
        if (this$fixedChannels == null ? other$fixedChannels != null : !this$fixedChannels.equals(other$fixedChannels)) {
            return false;
        }
        String this$humusonKey = this.getHumusonKey();
        String other$humusonKey = other.getHumusonKey();
        return !(this$humusonKey == null ? other$humusonKey != null : !this$humusonKey.equals(other$humusonKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TmsCommonConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $company = this.getCompany();
        result = result * 59 + ($company == null ? 43 : $company.hashCode());
        String $engine = this.getEngine();
        result = result * 59 + ($engine == null ? 43 : $engine.hashCode());
        String $node = this.getNode();
        result = result * 59 + ($node == null ? 43 : $node.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getWatcherUrls());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $fixedChannels = this.getFixedChannels();
        result = result * 59 + ($fixedChannels == null ? 43 : $fixedChannels.hashCode());
        String $humusonKey = this.getHumusonKey();
        result = result * 59 + ($humusonKey == null ? 43 : $humusonKey.hashCode());
        return result;
    }

    public String toString() {
        return "TmsCommonConfig(company=" + this.getCompany() + ", engine=" + this.getEngine() + ", node=" + this.getNode() + ", watcherUrls=" + Arrays.deepToString(this.getWatcherUrls()) + ", key=" + this.getKey() + ", fixedChannels=" + this.getFixedChannels() + ", humusonKey=" + this.getHumusonKey() + ")";
    }
}

