/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.config;

import com.humuson.tms.config.annotation.TmsComponent;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
public class TmsBeanDefinitionRegistryPostProcessor
implements BeanDefinitionRegistryPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(TmsBeanDefinitionRegistryPostProcessor.class);
    private Map<String, String> componentRegistry = new HashMap<String, String>();
    private Map<String, String> tmsComponentRegistry = new HashMap<String, String>();
    private Map<String, String> autowiredRegistry = new HashMap<String, String>();
    private Map<String, BeanDefinition> removeWaitStateBeanDefinition = new HashMap<String, BeanDefinition>();
    private List<String> qulifiers = new ArrayList<String>();
    public static final String CONSTANTS_OBJECT = "java.lang.Object";

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        String[] beanNames = registry.getBeanDefinitionNames();
        HashMap<String, String> removeWaitStateTmsComponents = new HashMap<String, String>();
        HashMap<String, String> componentBeanNames = new HashMap<String, String>();
        for (String beanName : beanNames) {
            BeanDefinition beanDefinition = registry.getBeanDefinition(beanName);
            try {
                Annotation[] beanDefinitationAnnotations;
                Class<?> beanDefinitionClass;
                String beanClassName = beanDefinition.getBeanClassName();
                if (beanClassName == null || (beanDefinitionClass = Class.forName(beanClassName)) == null) continue;
                this.autowiredFieldScan(beanDefinitionClass, beanName);
                for (Annotation beanDefinitationAnnotation : beanDefinitationAnnotations = beanDefinitionClass.getAnnotations()) {
                    if (beanDefinitationAnnotation.annotationType() == StepScope.class) {
                        log.info("@StepScope annotaion. BeanDefinition Name [{}], Bean class[{}]", (Object)beanName, (Object)beanDefinitionClass.getName());
                    }
                    if (beanDefinitationAnnotation.annotationType() == TmsComponent.class) {
                        String tmsComponentName = ((TmsComponent)beanDefinitationAnnotation).key();
                        if (!tmsComponentName.isEmpty()) {
                            removeWaitStateTmsComponents.put(tmsComponentName, beanDefinitionClass.getName());
                            this.removeWaitStateBeanDefinition.put(tmsComponentName, beanDefinition);
                        }
                        log.info(" Scanned TmsComponent annotaion. BeanDefinition Name [{}]", (Object)beanName);
                        this.componentScanToBuffer(this.tmsComponentRegistry, beanDefinitionClass, beanName);
                        continue;
                    }
                    if (beanDefinitationAnnotation.annotationType() != Component.class) continue;
                    String componentName = ((Component)beanDefinitationAnnotation).value();
                    if (!componentName.isEmpty()) {
                        componentBeanNames.put(componentName, beanDefinitionClass.getName());
                    }
                    this.componentScanToBuffer(this.componentRegistry, beanDefinitionClass, beanName);
                }
            }
            catch (ClassNotFoundException ce) {
                log.error("class not found Exception", (Throwable)ce);
            }
            catch (Exception e) {
                log.error("TmsComponent bean[{}] scanning Exception", (Object)beanName, (Object)e);
                throw e;
            }
        }
        this.removeSameQulifierCompoent(registry, removeWaitStateTmsComponents, componentBeanNames);
        this.duplicateTmsComponentFilter(registry);
        this.bufferclear();
    }

    private void removeSameQulifierCompoent(BeanDefinitionRegistry registry, Map<String, String> removeWaitStateTmsComponents, Map<String, String> componentBeanNames) {
        if (log.isDebugEnabled()) {
            log.debug("qulifiers info[{}]", this.qulifiers);
            log.debug("tmsComponents key info[{}]", removeWaitStateTmsComponents);
            log.debug("components info[{}]", componentBeanNames);
        }
        for (String tmsComponentKey : removeWaitStateTmsComponents.keySet()) {
            if ("sampleItemReader".equals(tmsComponentKey)) {
                log.info("sampleItemReader tmsComponet value={}", (Object)this.qulifiers.contains(tmsComponentKey));
            }
            if (this.qulifiers.contains(tmsComponentKey) && componentBeanNames.containsKey(tmsComponentKey)) {
                log.info("Removed qulifier same bean [{}]", (Object)tmsComponentKey);
                this.removeTmsComponentBean(registry, removeWaitStateTmsComponents.get(tmsComponentKey), componentBeanNames.get(tmsComponentKey));
                continue;
            }
            if (!this.qulifiers.contains(tmsComponentKey) || componentBeanNames.containsKey(tmsComponentKey)) continue;
            log.info("Bean Definition change[{}] -> [{}]", (Object)this.tmsComponentRegistry.get(removeWaitStateTmsComponents.get(tmsComponentKey)), (Object)tmsComponentKey);
            registry.registerBeanDefinition(tmsComponentKey, this.removeWaitStateBeanDefinition.get(tmsComponentKey));
        }
    }

    private void bufferclear() {
        this.componentRegistry.clear();
        this.tmsComponentRegistry.clear();
        this.autowiredRegistry.clear();
    }

    private void duplicateTmsComponentFilter(BeanDefinitionRegistry registry) {
        for (String key : this.tmsComponentRegistry.keySet()) {
            if (key.equals(CONSTANTS_OBJECT) || !this.componentRegistry.containsKey(key) || !this.autowiredRegistry.containsKey(key)) continue;
            log.info("Removed Component key[{}] value[{}]", (Object)key, (Object)this.componentRegistry.containsKey(key));
            this.removeTmsComponentBean(registry, key);
        }
    }

    private void removeTmsComponentBean(BeanDefinitionRegistry registry, String key) {
        this.removeTmsComponentBean(registry, key, key);
    }

    private void removeTmsComponentBean(BeanDefinitionRegistry registry, String tmsComponentKey, String componentKey) {
        log.info("Removed TmsComponent bean [{}] because Custom bean[{}] injected.", (Object)this.tmsComponentRegistry.get(tmsComponentKey), (Object)this.componentRegistry.get(componentKey));
        registry.removeBeanDefinition(this.tmsComponentRegistry.get(tmsComponentKey));
    }

    private void componentScanToBuffer(Map<String, String> registryComponent, Class<?> beanDefinitionClass, String beanName) {
        Class<?>[] interfaceClasses;
        Class<?> superClass = beanDefinitionClass.getSuperclass();
        if (superClass != null) {
            this.componentScanToBuffer(registryComponent, superClass, beanName);
        }
        if ((interfaceClasses = beanDefinitionClass.getInterfaces()) != null) {
            for (Class<?> interfaceClass : interfaceClasses) {
                this.componentScanToBuffer(registryComponent, interfaceClass, beanName);
            }
        }
        registryComponent.put(beanDefinitionClass.getName(), beanName);
    }

    public void autowiredFieldScan(Class<?> beanDefinitionClass, String beanName) {
        Field[] fields;
        for (Field field : fields = beanDefinitionClass.getDeclaredFields()) {
            Annotation[] annotations = field.getAnnotations();
            if (this.findQulifier(field, annotations)) continue;
            for (Annotation annotation : annotations) {
                if (annotation.annotationType() != Autowired.class) continue;
                Class<?> autoWiredClass = field.getType();
                this.autowiredRegistry.put(autoWiredClass.getName(), beanName);
            }
        }
    }

    private boolean findQulifier(Field field, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != Qualifier.class) continue;
            Qualifier qualifier = (Qualifier)annotation;
            if (!qualifier.value().isEmpty()) {
                this.qulifiers.add(qualifier.value());
            }
            if (log.isDebugEnabled()) {
                log.debug("this field[{}] is @Qualifier({}). Excluded from scan related to TmsComponent", (Object)field.getName(), (Object)qualifier.value());
            }
            return true;
        }
        return false;
    }
}

