/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.config;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class TmsAsyncTaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(TmsAsyncTaskExecutor.class);
    @Value(value="${async.thread.core-pool:30}")
    private int corePoolSize;
    @Value(value="${async.thread.max-pool:50}")
    private int maxPoolSize;
    @Value(value="${async.queue.capacity:80}")
    private int queueCapacity;
    @Value(value="${async.thread.timeout:180}")
    private int threadTimeout;

    @Bean
    @Qualifier(value="asyncTaskExecutor")
    public ThreadPoolTaskExecutor threadPoolTaskExecutor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(this.corePoolSize);
        threadPoolTaskExecutor.setMaxPoolSize(this.maxPoolSize);
        threadPoolTaskExecutor.setQueueCapacity(this.queueCapacity);
        threadPoolTaskExecutor.setKeepAliveSeconds(this.threadTimeout);
        return threadPoolTaskExecutor;
    }

    public class HandlingExecutor
    implements AsyncTaskExecutor {
        private AsyncTaskExecutor executor;

        public HandlingExecutor(AsyncTaskExecutor executor) {
            this.executor = executor;
        }

        public void execute(Runnable task) {
            this.executor.execute(task);
        }

        public void execute(Runnable task, long startTimeout) {
            this.executor.execute(this.createWrappedRunnable(task), startTimeout);
        }

        private <T> Callable<T> createCallable(final Callable<T> task) {
            return new Callable<T>(){

                @Override
                public T call() throws Exception {
                    try {
                        return task.call();
                    }
                    catch (Exception ex) {
                        HandlingExecutor.this.handle(ex);
                        throw ex;
                    }
                }
            };
        }

        private Runnable createWrappedRunnable(final Runnable task) {
            return new Runnable(){

                @Override
                public void run() {
                    try {
                        task.run();
                    }
                    catch (Exception ex) {
                        HandlingExecutor.this.handle(ex);
                    }
                }
            };
        }

        private void handle(Exception ex) {
            log.info("Failed to execute task. : {}", (Object)ex.getMessage());
            log.error("Failed to execute task. ", (Throwable)ex);
        }

        public Future<?> submit(Runnable task) {
            return this.executor.submit(this.createWrappedRunnable(task));
        }

        public <T> Future<T> submit(Callable<T> task) {
            return this.executor.submit(this.createCallable(task));
        }
    }
}

