/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch;

import com.humuson.tms.config.Column;
import com.humuson.tms.util.charset.FileControlUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.file.FlatFileItemReader;
import org.springframework.batch.item.file.LineMapper;
import org.springframework.batch.item.file.mapping.DefaultLineMapper;
import org.springframework.batch.item.file.mapping.FieldSetMapper;
import org.springframework.batch.item.file.transform.DelimitedLineTokenizer;
import org.springframework.batch.item.file.transform.FieldSet;
import org.springframework.batch.item.file.transform.LineTokenizer;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindException;

@Component
public class FileReader<T> {
    private static final Logger log = LoggerFactory.getLogger(FileReader.class);

    @Bean
    @StepScope
    public ItemReader<HashMap<String, T>> getReader(HashMap<String, T> mapTotalInfo) throws Exception {
        String fullPathFileName = String.valueOf(mapTotalInfo.get(Column.TARGET_FILE_NAME));
        String delimiter = "|";
        if (delimiter.equalsIgnoreCase("|")) {
            delimiter = "\\|";
        }
        Object[] fieldSetList = String.valueOf(mapTotalInfo.get(Column.MAPPING_HEADER)).split(delimiter);
        String charset = FileControlUtil.charsetFile(fullPathFileName);
        if (charset == null || charset.isEmpty()) {
            charset = Charset.defaultCharset().name();
        }
        delimiter = String.valueOf(mapTotalInfo.get(Column.TARGET_FILE_DELIM));
        boolean firstSkip = "Y".equalsIgnoreCase(String.valueOf(mapTotalInfo.get(Column.TARGET_FILE_HEAD_FLAG)));
        String targetFileIdx = String.valueOf(mapTotalInfo.get(Column.TARGET_FILE_IDX));
        DelimitedLineTokenizer delimitedLineTokenizer = new DelimitedLineTokenizer(delimiter);
        delimitedLineTokenizer.setNames((String[])fieldSetList);
        delimitedLineTokenizer.setStrict(false);
        FileTargetDataRowMapper fileTargetDataRowMapper = new FileTargetDataRowMapper();
        fileTargetDataRowMapper.setTargetFileIdx(targetFileIdx);
        DefaultLineMapper defaultLineMapper = new DefaultLineMapper();
        defaultLineMapper.setLineTokenizer((LineTokenizer)delimitedLineTokenizer);
        defaultLineMapper.setFieldSetMapper((FieldSetMapper)fileTargetDataRowMapper);
        log.debug("FILE TARGETING. charset : [{}], delimiter : [{}], firstSkip : [{}],  targetFileIdx = [{}], filed list : [{}]", new Object[]{charset, delimiter, firstSkip, targetFileIdx, Arrays.toString(fieldSetList)});
        FlatFileItemReader flatFileItemReader = new FlatFileItemReader();
        flatFileItemReader.setResource((Resource)new FileSystemResource(fullPathFileName));
        flatFileItemReader.setEncoding(charset);
        if (firstSkip) {
            flatFileItemReader.setLinesToSkip(1);
        }
        flatFileItemReader.setLineMapper((LineMapper)defaultLineMapper);
        flatFileItemReader.setName(String.valueOf(mapTotalInfo.get(Column.JOB_NAME)));
        return flatFileItemReader;
    }

    @Bean
    @StepScope
    public ItemReader<Map<String, T>> getReaderByMap(Map<String, T> mapTotalInfo) throws Exception {
        String fullPathFileName = String.valueOf(mapTotalInfo.get(Column.TARGET_FILE_NAME));
        String delimiter = "|";
        if (delimiter.equalsIgnoreCase("|")) {
            delimiter = "\\|";
        }
        Object[] fieldSetList = String.valueOf(mapTotalInfo.get(Column.MAPPING_HEADER)).split(delimiter);
        String charset = FileControlUtil.charsetFile(fullPathFileName);
        if (charset == null || charset.isEmpty()) {
            charset = Charset.defaultCharset().name();
        }
        delimiter = String.valueOf(mapTotalInfo.get(Column.TARGET_FILE_DELIM));
        boolean firstSkip = "Y".equalsIgnoreCase(String.valueOf(mapTotalInfo.get(Column.TARGET_FILE_HEAD_FLAG)));
        String targetFileIdx = String.valueOf(mapTotalInfo.get(Column.TARGET_FILE_IDX));
        DelimitedLineTokenizer delimitedLineTokenizer = new DelimitedLineTokenizer(delimiter);
        delimitedLineTokenizer.setNames((String[])fieldSetList);
        delimitedLineTokenizer.setStrict(false);
        FileTargetDataRowMapper fileTargetDataRowMapper = new FileTargetDataRowMapper();
        fileTargetDataRowMapper.setTargetFileIdx(targetFileIdx);
        DefaultLineMapper defaultLineMapper = new DefaultLineMapper();
        defaultLineMapper.setLineTokenizer((LineTokenizer)delimitedLineTokenizer);
        defaultLineMapper.setFieldSetMapper((FieldSetMapper)fileTargetDataRowMapper);
        log.debug("FILE TARGETING. charset : [{}], delimiter : [{}], firstSkip : [{}],  targetFileIdx = [{}], filed list : [{}]", new Object[]{charset, delimiter, firstSkip, targetFileIdx, Arrays.toString(fieldSetList)});
        FlatFileItemReader flatFileItemReader = new FlatFileItemReader();
        flatFileItemReader.setResource((Resource)new FileSystemResource(fullPathFileName));
        flatFileItemReader.setEncoding(charset);
        if (firstSkip) {
            flatFileItemReader.setLinesToSkip(1);
        }
        flatFileItemReader.setLineMapper((LineMapper)defaultLineMapper);
        flatFileItemReader.setName(String.valueOf(mapTotalInfo.get(Column.JOB_NAME)));
        return flatFileItemReader;
    }

    class FileTargetDataRowMapper
    implements FieldSetMapper<HashMap<String, Object>> {
        private int fieldSetCount = 0;
        private List<Integer> targetFileIdxList = new ArrayList<Integer>();

        FileTargetDataRowMapper() {
        }

        public HashMap<String, Object> mapFieldSet(FieldSet fieldSet) throws BindException {
            if (this.fieldSetCount == 0) {
                this.fieldSetCount = fieldSet.getFieldCount();
            }
            if (log.isDebugEnabled()) {
                log.debug("fieldSet names:{}, values:{}", (Object)fieldSet.getNames().length, (Object)fieldSet.getValues().length);
            }
            String[] names = fieldSet.getNames();
            String[] values = fieldSet.getValues();
            HashMap<String, Object> target = new HashMap<String, Object>();
            try {
                int size = this.targetFileIdxList.size();
                for (int i = 0; i < size; ++i) {
                    if (this.targetFileIdxList.get(i) < 0) continue;
                    target.put(names[i].trim(), values[this.targetFileIdxList.get(i)]);
                }
            }
            catch (Exception e) {
                log.error("target data bind error [{}]", (Object)fieldSet.getProperties().toString());
                throw new BindException((Object)this, "fieldSetBind Error");
            }
            return target;
        }

        public void setTargetFileIdx(String targetFileIdx) {
            for (String idx : targetFileIdx.split("[|]")) {
                try {
                    this.targetFileIdxList.add(Integer.parseInt(idx));
                }
                catch (Exception e) {
                    log.error("idx parse error [targetFileIdx:{}, idx:{}]", (Object)targetFileIdx, (Object)idx);
                    this.targetFileIdxList.add(-1);
                }
            }
        }
    }
}

