/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
public class DBReader<T> {
    private static final Logger log = LoggerFactory.getLogger(DBReader.class);

    @Bean
    @StepScope
    public ItemReader<Map<String, T>> getJdbcReader(DataSource dataSource, String sql, int chunkSize) throws Exception {
        JdbcCursorItemReader cusorItemReader = new JdbcCursorItemReader<Map<String, T>>(){

            @BeforeStep
            public void beforeStep(StepExecution stepExecution) {
                long callCenterId = stepExecution.getJobParameters().getLong("callCent erId");
            }
        };
        RowMapper<Map<String, Object>> rowMapper = this.getRowMapper();
        cusorItemReader.setDataSource(dataSource);
        cusorItemReader.setRowMapper(rowMapper);
        cusorItemReader.setFetchSize(chunkSize);
        cusorItemReader.setVerifyCursorPosition(false);
        log.info("item reader dataSource = {}", (Object)dataSource);
        log.info("item reader sql = {}", (Object)sql);
        cusorItemReader.setSql(sql);
        cusorItemReader.afterPropertiesSet();
        return cusorItemReader;
    }

    private RowMapper<Map<String, Object>> getRowMapper() {
        return new RowMapper<Map<String, Object>>(){

            public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
                return this.commonRowMapping(rs);
            }

            protected Map<String, Object> commonRowMapping(ResultSet rs) throws SQLException {
                HashMap<String, Object> mapping = new HashMap<String, Object>();
                ResultSetMetaData rsmd = rs.getMetaData();
                int cnt = rsmd.getColumnCount();
                for (int loop = 0; loop < cnt; ++loop) {
                    mapping.put(rsmd.getColumnLabel(loop + 1), rs.getObject(loop + 1));
                }
                return mapping;
            }
        };
    }
}

