/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.trans.simple;

import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.file.FlatFileItemWriter;
import org.springframework.batch.item.file.transform.BeanWrapperFieldExtractor;
import org.springframework.batch.item.file.transform.DelimitedLineAggregator;
import org.springframework.batch.item.file.transform.FieldExtractor;
import org.springframework.batch.item.file.transform.LineAggregator;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public enum FlatFileItemFactory {
    INSTANCE;


    public FlatFileController instance(String csvFile, String[] fieldList) {
        return new FlatFileController(csvFile, fieldList);
    }

    public class FlatFileController<T> {
        private final String csvFile;
        private final String[] fieldSetList;

        public FlatFileController(String csvFile, String[] fieldList) {
            this.csvFile = csvFile;
            this.fieldSetList = new String[fieldList.length];
            System.arraycopy(fieldList, 0, this.fieldSetList, 0, fieldList.length);
        }

        public FlatFileItemWriter<T> build() {
            FlatFileItemWriter writer = new FlatFileItemWriter();
            writer.setResource((Resource)new FileSystemResource(this.csvFile));
            DelimitedLineAggregator delLineAgg = new DelimitedLineAggregator();
            delLineAgg.setDelimiter(",");
            BeanWrapperFieldExtractor fieldExtractor = new BeanWrapperFieldExtractor();
            fieldExtractor.setNames(this.fieldSetList);
            delLineAgg.setFieldExtractor((FieldExtractor)fieldExtractor);
            writer.setLineAggregator((LineAggregator)delLineAgg);
            writer.setAppendAllowed(false);
            ExecutionContext context = new ExecutionContext();
            writer.open(context);
            return writer;
        }
    }
}

