/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.trans.simple;

import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.file.FlatFileItemReader;
import org.springframework.batch.item.file.FlatFileItemWriter;
import org.springframework.batch.item.file.LineMapper;
import org.springframework.batch.item.file.mapping.BeanWrapperFieldSetMapper;
import org.springframework.batch.item.file.mapping.DefaultLineMapper;
import org.springframework.batch.item.file.mapping.FieldSetMapper;
import org.springframework.batch.item.file.transform.BeanWrapperFieldExtractor;
import org.springframework.batch.item.file.transform.DelimitedLineAggregator;
import org.springframework.batch.item.file.transform.DelimitedLineTokenizer;
import org.springframework.batch.item.file.transform.FieldExtractor;
import org.springframework.batch.item.file.transform.LineAggregator;
import org.springframework.batch.item.file.transform.LineTokenizer;
import org.springframework.context.annotation.Bean;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public enum FlatFileItemAssembly {
    FILE_TO_DB,
    DB_TO_DB;


    public <T> FlatFileTargetHandler<T> fileInstance(String fullPathFileName, String[] fieldList) {
        return new FlatFileTargetHandler(fullPathFileName, fieldList);
    }

    public class FlatFileTargetHandler<T> {
        private final String csvFile;
        private final String[] fieldSetList;
        private Class<T> genericType;

        public FlatFileTargetHandler(String csvFile, String[] fieldList) {
            this.csvFile = csvFile;
            this.fieldSetList = new String[fieldList.length];
            System.arraycopy(fieldList, 0, this.fieldSetList, 0, fieldList.length);
        }

        @Bean
        FlatFileItemReader<T> fileItemReader(String fullPathFileName, String delimiter, boolean firstLineSkip) {
            FlatFileItemReader flatFileItemReader = new FlatFileItemReader();
            flatFileItemReader.setResource((Resource)new ClassPathResource(fullPathFileName));
            if (firstLineSkip) {
                flatFileItemReader.setLinesToSkip(1);
            }
            DefaultLineMapper defaultLineMapper = new DefaultLineMapper();
            DelimitedLineTokenizer delimitedLineTokenizer = new DelimitedLineTokenizer();
            delimitedLineTokenizer.setDelimiter(delimiter);
            delimitedLineTokenizer.setNames(this.fieldSetList);
            BeanWrapperFieldSetMapper fieldSetMapper = new BeanWrapperFieldSetMapper();
            this.genericType = GenericTypeResolver.resolveTypeArgument(this.getClass(), FlatFileTargetHandler.class);
            fieldSetMapper.setTargetType(this.genericType);
            defaultLineMapper.setLineTokenizer((LineTokenizer)delimitedLineTokenizer);
            defaultLineMapper.setFieldSetMapper((FieldSetMapper)fieldSetMapper);
            flatFileItemReader.setLineMapper((LineMapper)defaultLineMapper);
            return flatFileItemReader;
        }

        public FlatFileItemWriter<T> fileItemWriter(String fullPathFileName, String delimiter) {
            FlatFileItemWriter writer = new FlatFileItemWriter();
            writer.setResource((Resource)new FileSystemResource(fullPathFileName));
            DelimitedLineAggregator delLineAgg = new DelimitedLineAggregator();
            delLineAgg.setDelimiter(",");
            BeanWrapperFieldExtractor fieldExtractor = new BeanWrapperFieldExtractor();
            fieldExtractor.setNames(this.fieldSetList);
            delLineAgg.setFieldExtractor((FieldExtractor)fieldExtractor);
            writer.setLineAggregator((LineAggregator)delLineAgg);
            writer.setAppendAllowed(false);
            ExecutionContext context = new ExecutionContext();
            writer.open(context);
            return writer;
        }
    }
}

