/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.trans.simple;

import com.humuson.tms.adaptor.trans.simple.Destination;
import java.io.Reader;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class DbDestination<T>
implements Destination<T> {
    @Autowired
    protected SqlSession sqlSession;

    @Override
    public void commit() throws Exception {
        this.sqlSession.commit();
    }

    @Override
    public void finish() throws Exception {
        this.sqlSession.commit(true);
        this.sqlSession.close();
    }

    @Override
    public void initial(String resource) throws Exception {
        this.sqlSession.close();
        Reader reader = Resources.getResourceAsReader((String)resource);
        SqlSessionFactoryBuilder builder = new SqlSessionFactoryBuilder();
        SqlSessionFactory factory = builder.build(reader);
        this.sqlSession = factory.openSession(ExecutorType.BATCH);
        this.sqlSession.commit(false);
    }
}

