/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.trans.simple;

import com.humuson.tms.adaptor.trans.simple.FileDestination;
import com.humuson.tms.adaptor.trans.simple.FlatFileItemFactory;
import com.humuson.tms.adaptor.trans.simple.WriterOption;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.file.FlatFileItemWriter;
import org.springframework.beans.factory.annotation.Value;

public class CsvFileDestination<T>
extends FileDestination<T> {
    private static final Logger log = LoggerFactory.getLogger(CsvFileDestination.class);
    private final String[] fields;
    private FlatFileItemWriter<T> csvWriter;
    private List<T> content;
    @Value(value="${tms.database.commit-count:1000}")
    private String dir;

    public CsvFileDestination(String[] fields) {
        this.fields = fields;
        this.content = new ArrayList<T>();
    }

    @Override
    public void initial(String fileName) throws Exception {
        fileName = fileName.toLowerCase().endsWith(".csv") ? fileName : fileName + ".csv";
        this.csvWriter = FlatFileItemFactory.INSTANCE.instance(this.dir + fileName, this.fields).build();
    }

    @Override
    public void write(WriterOption option, T t) {
        this.content.add(t);
    }

    @Override
    public void commit() throws Exception {
        try {
            this.csvWriter.write(this.content);
        }
        catch (Exception e) {
            log.error("error csv writer commit content {}", this.content);
        }
        finally {
            this.content.clear();
        }
    }

    @Override
    public void finish() throws Exception {
        this.csvWriter.close();
    }
}

