/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.trans.simple;

import com.humuson.tms.adaptor.trans.simple.AbstractBigDataExecutorHandler;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BigDataSqlExecutor<P> {
    private static final Logger log = LoggerFactory.getLogger(BigDataSqlExecutor.class);
    private AbstractBigDataExecutorHandler bigDataExecutorHandler;
    @Autowired
    private SqlSessionFactory sqlSessionFactory;

    public void setBigDataSqlExecutor(AbstractBigDataExecutorHandler bigDataExecutorHandler) {
        this.bigDataExecutorHandler = bigDataExecutorHandler;
    }

    public void selectAndExecutor() throws Exception {
        this.selectAndExecutor(null);
    }

    public SqlSession getSqlSession(boolean isBatch) {
        if (isBatch) {
            return this.sqlSessionFactory.openSession(ExecutorType.BATCH);
        }
        return this.sqlSessionFactory.openSession();
    }

    public void selectAndExecutor(P parameter) throws Exception {
        SqlSession selectSession = null;
        Object dmlSession = null;
        try {
            selectSession = this.sqlSessionFactory.openSession();
            if (parameter == null) {
                selectSession.select(this.bigDataExecutorHandler.getDaoId(), (ResultHandler)this.bigDataExecutorHandler);
            } else {
                selectSession.select(this.bigDataExecutorHandler.getDaoId(), parameter, (ResultHandler)this.bigDataExecutorHandler);
            }
            try {
                this.bigDataExecutorHandler.finish();
            }
            catch (Exception e) {
                log.error("last dml Query Position[{}] Exception {}", (Object)this.bigDataExecutorHandler.doneCount(), (Object)e.toString());
            }
        }
        catch (Exception e) {
            log.error("don't select and executor session.select() DaoId[{}] Handler Name[{}] Exception", (Object)this.bigDataExecutorHandler.getDaoId(), (Object)this.bigDataExecutorHandler.getClass().getName());
            throw e;
        }
        finally {
            try {
                if (selectSession != null) {
                    selectSession.close();
                }
            }
            catch (Exception e2) {
                log.error("don't session close big data Exception {}", (Object)e2.toString());
            }
        }
    }
}

