/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.trans.simple;

import com.humuson.tms.adaptor.trans.simple.BigDataSql;
import com.humuson.tms.adaptor.trans.simple.Destination;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public abstract class AbstractBigDataExecutorHandler
implements ResultHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractBigDataExecutorHandler.class);
    protected final AtomicInteger commit = new AtomicInteger(0);
    protected static int COMMIT_COUNT = 1000;
    protected final BigDataSql bigDataSql;
    protected Destination destination;
    protected long end = 0L;
    private int nowCommitCount;
    private int totalCommitCount;
    @Value(value="${tms.database.commit-count:1000}")
    private int commitCount;

    public AbstractBigDataExecutorHandler(BigDataSql bigDataSql) {
        this.bigDataSql = bigDataSql;
        this.destination = bigDataSql.getDestination();
        this.setCommitCount();
    }

    public AbstractBigDataExecutorHandler(String key, String from, String to) {
        this.bigDataSql = new BigDataSql(key, from);
        this.setCommitCount();
    }

    public void setCommitCount() {
        COMMIT_COUNT = this.bigDataSql.getCommitCount() == 0 ? this.commitCount : this.bigDataSql.getCommitCount();
    }

    public String getDaoId() {
        return this.bigDataSql.getSelectDaoid();
    }

    public void commit() throws Exception {
        this.destination.commit();
    }

    public void init(String resource) throws Exception {
        this.destination.initial(resource);
    }

    public void finish() {
        try {
            this.commit();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                this.destination.finish();
            }
            catch (Exception exception) {}
        }
    }

    public void handleResult(ResultContext context) {
        try {
            this.oneRowResultExecutor(context);
            ++this.nowCommitCount;
            ++this.totalCommitCount;
            if (this.nowCommitCount > COMMIT_COUNT) {
                long start = System.currentTimeMillis();
                this.nowCommitCount = 0;
                log.info("key[{}] commit Count[{}] - (" + (start - this.end) / 1000L + "s)", (Object)this.bigDataSql.getName(), (Object)this.totalCommitCount);
                this.end = start;
                try {
                    this.commit();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            log.error("error executor Exception {}", (Object)e.toString());
        }
    }

    public int doneCount() {
        return this.commit.get();
    }

    protected abstract void oneRowResultExecutor(ResultContext var1) throws Exception;
}

