/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.redis;

import com.humuson.tms.adaptor.redis.CrsltKeyRepository;
import com.humuson.tms.adaptor.redis.RedissonAutoConfiguration;
import com.humuson.tms.adaptor.redis.SentinelRedisConfig;
import com.humuson.tms.util.json.JsonConvertUtil;
import com.humuson.tms.util.seq.TimeUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisSentinelConnection;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import redis.clients.jedis.exceptions.JedisConnectionException;

@Component
@ConditionalOnBean(name={"sentinelRedisConfig"})
public class WrapperRedisTemplate {
    private static final Logger log = LoggerFactory.getLogger(WrapperRedisTemplate.class);
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired(required=false)
    private SentinelRedisConfig redisConfig;
    HashOperations<String, Object, Object> hops;
    HashOperations<String, String, String> stringHops;
    ValueOperations<String, String> vops;
    ValueOperations<String, Object> objs;
    ZSetOperations<String, String> zSet;
    @Autowired(required=false)
    RedissonAutoConfiguration redissonAutoConfiguration;
    Consumer<String> setCrsltKey = key -> {
        if (key.startsWith("CRSLT:") && CrsltKeyRepository.INSTANCE.setCrsltKey((String)key)) {
            this.zAddTxt("CRSLT_KEY", (String)key, Double.parseDouble(key.substring(9)));
        }
    };

    public StringRedisTemplate redisTemplate() {
        return this.stringRedisTemplate;
    }

    public void setStringRedisTemplate(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }

    @PostConstruct
    public void init() {
        this.hops = this.stringRedisTemplate.opsForHash();
        this.stringHops = this.stringRedisTemplate.opsForHash();
        this.vops = this.stringRedisTemplate.opsForValue();
        this.zSet = this.stringRedisTemplate.opsForZSet();
    }

    private void reconnect(int time) {
        try {
            if ((time *= 2) < 5) {
                time = 5;
            }
            log.info("redis connector delay term[{}] ", (Object)time);
            TimeUtil.secondsLockSleep(time);
        }
        catch (Exception e) {
            log.error("redis connecting fail \nreconneting redis millisecond cycle[{}]", (Object)time, (Object)e);
        }
    }

    private void reconnect_org(int time) {
        try {
            log.info("redis connector delay term[{}] ", (Object)time);
            TimeUtil.secondsLockSleep(time);
            this.close();
            this.redisConfig.jedisConnectionFactory();
            this.init();
            RedisSentinelConnection connection = this.stringRedisTemplate.getConnectionFactory().getSentinelConnection();
            if (!connection.isOpen()) {
                this.reconnect(time * 2);
            }
        }
        catch (Exception e) {
            log.error("redis connecting fail \nreconneting redis millisecond cycle[{}]", (Object)time, (Object)e);
            this.reconnect(time * 2);
        }
    }

    public long zAddTxt(String key, Set<ZSetOperations.TypedTuple<String>> tuples) {
        return this.zSet.add((Object)key, tuples);
    }

    public boolean zAddTxt(String key, String value, double score) {
        return this.zSet.add((Object)key, (Object)value, score);
    }

    public Set<String> zRange(String key, long start, long end) {
        return this.zSet.range((Object)key, start, end);
    }

    public Set<String> zRange(String key) {
        return this.zSet.range((Object)key, 0L, -1L);
    }

    public long zCard(String key) {
        return this.zSet.zCard((Object)key);
    }

    public long zDel(String key, long start, long end) {
        return this.zSet.removeRange((Object)key, start, end);
    }

    public long zDel(String key, String ... values) {
        return this.zSet.remove((Object)key, (Object[])values);
    }

    public Map<Object, Object> hgetAll(String key) throws Exception {
        try {
            return this.hops.entries((Object)key);
        }
        catch (RedisConnectionFailureException rfe) {
            log.error("error connection so reconnect / get key[{}]", (Object)key, (Object)rfe);
            this.reconnect(1);
            return this.hgetAll(key);
        }
        catch (JedisConnectionException je) {
            log.error("error connection so reconnect / get key[{}]", (Object)key, (Object)je);
            this.reconnect(1);
            return this.hgetAll(key);
        }
        catch (Exception e) {
            log.error("fail call redis so return <null> ", (Throwable)e);
            return null;
        }
    }

    public String hmget(String key, String field) throws Exception {
        try {
            return (String)this.stringHops.get((Object)key, (Object)field);
        }
        catch (RedisConnectionFailureException rfe) {
            log.error("error connection so reconnect / get key[{}] field[{}]", new Object[]{key, field, rfe});
            this.reconnect(1);
            return this.hmget(key, field);
        }
        catch (JedisConnectionException je) {
            log.error("error connection so reconnect / get key[{}] field[{}]", new Object[]{key, field, je});
            this.reconnect(1);
            return this.hmget(key, field);
        }
        catch (Exception e) {
            log.error("fail call redis so return <null> ", (Throwable)e);
            return null;
        }
    }

    public String defaultGet(String key) throws Exception {
        try {
            return (String)this.vops.get((Object)key);
        }
        catch (RedisConnectionFailureException rfe) {
            log.error("error connection so reconnect / get key[{}]", (Object)key, (Object)rfe);
            this.reconnect(1);
            return this.defaultGet(key);
        }
        catch (JedisConnectionException je) {
            log.error("error connection so reconnect / get key[{}]", (Object)key, (Object)je);
            this.reconnect(1);
            return this.defaultGet(key);
        }
        catch (Exception e) {
            log.error("fail call redis so return <null> ", (Throwable)e);
            return null;
        }
    }

    public long incr(String key, long number) throws Exception {
        try {
            return this.vops.increment((Object)key, number);
        }
        catch (RedisConnectionFailureException rfe) {
            log.error("error connection so reconnect / get key[{}]", (Object)key, (Object)rfe);
            this.reconnect(1);
            return this.incr(key, number);
        }
        catch (JedisConnectionException je) {
            log.error("error connection so reconnect / get key[{}]", (Object)key, (Object)je);
            this.reconnect(1);
            return this.incr(key, number);
        }
        catch (Exception e) {
            log.error("fail call redis so return <null> ", (Throwable)e);
            return -1L;
        }
    }

    public boolean hasHMKey(String key, String hashKey) throws Exception {
        try {
            return this.hops.hasKey((Object)key, (Object)hashKey);
        }
        catch (RedisConnectionFailureException rfe) {
            log.error("error connection so reconnect / get key[{}]", (Object)key, (Object)rfe);
            this.reconnect(1);
            return this.hasHMKey(key, hashKey);
        }
        catch (JedisConnectionException je) {
            log.error("error connection so reconnect / get key[{}]", (Object)key, (Object)je);
            this.reconnect(1);
            return this.hasHMKey(key, hashKey);
        }
        catch (Exception e) {
            log.error("fail call redis so return <null> ", (Throwable)e);
            return false;
        }
    }

    public void set(String key, String value) throws Exception {
        try {
            if (!StringUtils.isEmpty((CharSequence)value)) {
                this.setCrsltKey.accept(key);
            }
            this.vops.set((Object)key, (Object)value);
        }
        catch (RedisConnectionFailureException rfe) {
            log.error("error connection so reconnect / key[{}],  value[{}]", new Object[]{key, value, rfe});
            this.reconnect(1);
            this.set(key, value);
        }
        catch (JedisConnectionException je) {
            log.error("error connection so reconnect / key[{}],  value[{}]", new Object[]{key, value, je});
            this.reconnect(1);
            this.set(key, value);
        }
        catch (Exception e) {
            throw e;
        }
    }

    public void hmset(String key, String field, String value) throws Exception {
        try {
            if (!StringUtils.isEmpty((CharSequence)value)) {
                this.setCrsltKey.accept(key);
            }
            this.hops.put((Object)key, (Object)field, (Object)value);
        }
        catch (RedisConnectionFailureException rfe) {
            log.error("error connection so reconnect / key[{}] field[{}], value[{}]", new Object[]{key, field, value, rfe});
            this.reconnect(1);
            this.hmset(key, field, value);
        }
        catch (JedisConnectionException je) {
            log.error("error connection so reconnect / key[{}] field[{}], value[{}]", new Object[]{key, field, value, je});
            this.reconnect(1);
            this.hmset(key, field, value);
        }
        catch (Exception e) {
            throw e;
        }
    }

    public boolean hmsetNX(String key, String field, String value) throws Exception {
        try {
            if (!StringUtils.isEmpty((CharSequence)value)) {
                this.setCrsltKey.accept(key);
            }
            return this.hops.putIfAbsent((Object)key, (Object)field, (Object)value);
        }
        catch (RedisConnectionFailureException rfe) {
            log.error("error connection so reconnect / key[{}] field[{}], value[{}]", new Object[]{key, field, value, rfe});
            this.reconnect(1);
            return this.hmsetNX(key, field, value);
        }
        catch (JedisConnectionException je) {
            log.error("error connection so reconnect / key[{}] field[{}], value[{}]", new Object[]{key, field, value, je});
            this.reconnect(1);
            return this.hmsetNX(key, field, value);
        }
        catch (Exception e) {
            log.error("fail call redis so return <null> ", (Throwable)e);
            return false;
        }
    }

    public void hmsetAll(String key, Map<String, String> map) throws Exception {
        try {
            this.hops.putAll((Object)key, map);
        }
        catch (RedisConnectionFailureException rfe) {
            log.error("error connection so reconnect / key[{}] map.size()[{}]", new Object[]{key, map.size(), rfe});
            this.reconnect(1);
            this.hmsetAll(key, map);
        }
        catch (JedisConnectionException je) {
            log.error("error connection so reconnect / key[{}] map.size()[{}]", new Object[]{key, map.size(), je});
            this.reconnect(1);
            this.hmsetAll(key, map);
        }
        catch (Exception e) {
            throw e;
        }
    }

    public void hmsetAllObject(String key, Map<Object, Object> map) throws Exception {
        try {
            this.hops.putAll((Object)key, map);
        }
        catch (RedisConnectionFailureException rfe) {
            log.error("error connection so reconnect / key[{}] map.size()[{}]", new Object[]{key, map.size(), rfe});
            this.reconnect(1);
            this.hmsetAllObject(key, map);
        }
        catch (JedisConnectionException je) {
            log.error("error connection so reconnect / key[{}] map.size()[{}]", new Object[]{key, map.size(), je});
            this.reconnect(1);
            this.hmsetAllObject(key, map);
        }
        catch (Exception e) {
            throw e;
        }
    }

    public Map<String, String> hgetAllString(String key) throws Exception {
        try {
            return this.stringHops.entries((Object)key);
        }
        catch (RedisConnectionFailureException rfe) {
            log.error("error connection so reconnect / get key[{}]", (Object)key, (Object)rfe);
            this.reconnect(1);
            return this.hgetAllString(key);
        }
        catch (JedisConnectionException je) {
            log.error("error connection so reconnect / get key[{}]", (Object)key, (Object)je);
            this.reconnect(1);
            return this.hgetAllString(key);
        }
        catch (Exception e) {
            log.error("fail call redis so return <null> ", (Throwable)e);
            return null;
        }
    }

    public boolean hmHasKey(String key, String field) throws Exception {
        try {
            return this.stringHops.hasKey((Object)key, (Object)field);
        }
        catch (RedisConnectionFailureException rfe) {
            log.error("error connection so reconnect / get key[{}]", (Object)key, (Object)rfe);
            this.reconnect(1);
            return this.hmHasKey(key, field);
        }
        catch (JedisConnectionException je) {
            log.error("error connection so reconnect / get key[{}]", (Object)key, (Object)je);
            this.reconnect(1);
            return this.hmHasKey(key, field);
        }
        catch (Exception e) {
            log.error("fail call redis so return <null> ", (Throwable)e);
            return false;
        }
    }

    public boolean hasKey(String key) throws Exception {
        try {
            return this.stringRedisTemplate.hasKey((Object)key);
        }
        catch (RedisConnectionFailureException rfe) {
            log.error("error connection so reconnect / get key[{}]", (Object)key, (Object)rfe);
            this.reconnect(1);
            return this.hasKey(key);
        }
        catch (JedisConnectionException je) {
            log.error("error connection so reconnect / get key[{}]", (Object)key, (Object)je);
            this.reconnect(1);
            return this.hasKey(key);
        }
        catch (Exception e) {
            log.error("fail call redis so return <null> ", (Throwable)e);
            return false;
        }
    }

    public void close() {
        if (this.stringRedisTemplate == null) {
            return;
        }
        try {
            RedisSentinelConnection connection = this.stringRedisTemplate.getConnectionFactory().getSentinelConnection();
            if (connection.isOpen()) {
                connection.close();
            }
        }
        catch (JedisConnectionException je) {
            log.error("redis connection error so session closed ", (Throwable)je);
            return;
        }
        catch (Exception e) {
            log.error("fail closing sentinel redis server so re closing", (Throwable)e);
            TimeUtil.mileSecondsLockSleep(3000);
            this.close();
        }
    }

    @Deprecated
    public List<String> scan(String sPattern, int scanCnt, int maxCnt) {
        ArrayList<String> result = new ArrayList<String>();
        ScanOptions options = ScanOptions.scanOptions().match(sPattern + "*").count((long)scanCnt).build();
        RedisConnection connection = this.stringRedisTemplate.getConnectionFactory().getConnection();
        Cursor c = connection.scan(options);
        String n = "";
        while (c.hasNext()) {
            n = new String((byte[])c.next());
            if (result.size() < maxCnt) {
                result.add(n);
            }
            if (result.size() < maxCnt) continue;
        }
        try {
            if (c != null && !c.isClosed()) {
                c.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public Map<String, String> hscan(String key, String sPattern, int scanCnt, int maxCnt) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (sPattern == null) {
            sPattern = "";
        }
        ScanOptions options = ScanOptions.scanOptions().match(sPattern + "*").count((long)scanCnt).build();
        RedisConnection connection = this.stringRedisTemplate.getConnectionFactory().getConnection();
        Cursor c = connection.hScan(key.getBytes(), options);
        Map.Entry n = null;
        String v = null;
        while (c.hasNext()) {
            n = (Map.Entry)c.next();
            if (result.size() < maxCnt && n.getValue() != null) {
                v = new String((byte[])n.getValue(), 0, ((byte[])n.getValue()).length);
            }
            if (v != null && !"".equals(v)) {
                result.put(new String((byte[])n.getKey(), 0, ((byte[])n.getKey()).length), new String((byte[])n.getValue(), 0, ((byte[])n.getValue()).length));
            }
            if (result.size() < maxCnt) continue;
        }
        try {
            if (c != null && !c.isClosed()) {
                c.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties info() {
        Properties prop = null;
        try (RedisConnection connection = RedisConnectionUtils.getConnection((RedisConnectionFactory)this.redisConfig.jedisConnectionFactory());){
            prop = connection.info();
        }
        catch (Exception e) {
            log.error("MN1531|Threshold Error : Redis getConnection ", (Throwable)e);
        }
        return prop;
    }

    public void hmdel(String key, String field) {
        try {
            this.hops.delete((Object)key, new Object[]{field});
        }
        catch (RedisConnectionFailureException rfe) {
            log.error("error connection so reconnect / key[{}] field[{}]", new Object[]{key, field, rfe});
            this.reconnect(1);
            this.hmdel(key, field);
        }
        catch (JedisConnectionException je) {
            log.error("error connection so reconnect / key[{}] field[{}]", new Object[]{key, field, je});
            this.reconnect(1);
            this.hmdel(key, field);
        }
        catch (Exception e) {
            throw e;
        }
    }

    public void del(String key) {
        try {
            this.stringRedisTemplate.delete((Object)key);
        }
        catch (RedisConnectionFailureException rfe) {
            log.error("error connection so reconnect / key[{}] field[{}]", (Object)key, (Object)rfe);
            this.reconnect(1);
            this.del(key);
        }
        catch (JedisConnectionException je) {
            log.error("error connection so reconnect / key[{}] field[{}]", (Object)key, (Object)je);
            this.reconnect(1);
            this.del(key);
        }
        catch (Exception e) {
            throw e;
        }
    }

    public void dels(Collection<String> keys) {
        try {
            this.stringRedisTemplate.delete(keys);
        }
        catch (RedisConnectionFailureException rfe) {
            log.error("error connection so reconnect / key[{}] field[{}]", keys, (Object)rfe);
            this.reconnect(1);
            this.dels(keys);
        }
        catch (JedisConnectionException je) {
            log.error("error connection so reconnect / key[{}] field[{}]", keys, (Object)je);
            this.reconnect(1);
            this.dels(keys);
        }
        catch (Exception e) {
            throw e;
        }
    }

    public long hincrby(String key, String field, long value) {
        long result = 0L;
        try {
            result = this.hops.increment((Object)key, (Object)field, value);
        }
        catch (RedisConnectionFailureException rfe) {
            log.error("error connection so reconnect / key[{}] field[{}]", new Object[]{key, field, rfe});
            this.reconnect(1);
            this.hincrby(key, field, value);
        }
        catch (JedisConnectionException je) {
            log.error("error connection so reconnect / key[{}] field[{}]", new Object[]{key, field, je});
            this.reconnect(1);
            this.hincrby(key, field, value);
        }
        catch (Exception e) {
            throw e;
        }
        return result;
    }

    public long hlen(String key) throws Exception {
        long result = 0L;
        try {
            result = this.hops.size((Object)key);
        }
        catch (RedisConnectionFailureException rfe) {
            log.error("error connection so reconnect / get key[{}]", (Object)key, (Object)rfe);
            this.reconnect(1);
            return this.hlen(key);
        }
        catch (JedisConnectionException je) {
            log.error("error connection so reconnect / get key[{}]", (Object)key, (Object)je);
            this.reconnect(1);
            return this.hlen(key);
        }
        catch (Exception e) {
            log.error("fail call redis so return <null> ", (Throwable)e);
        }
        return result;
    }

    public boolean isLock(String lockKey) {
        boolean result = true;
        long resultCnt = 0L;
        try {
            resultCnt = this.hops.size((Object)lockKey);
            if (resultCnt > 0L) {
                Map lockMap = this.stringHops.entries((Object)lockKey);
                for (String field : lockMap.keySet()) {
                    String value = (String)lockMap.get(field);
                    log.info("[LockController] {} {} {} is locked", new Object[]{lockKey, field, value});
                }
            } else {
                result = false;
            }
        }
        catch (RedisConnectionFailureException rfe) {
            log.error("error connection so reconnect / get key[{}]", (Object)lockKey, (Object)rfe);
            this.reconnect(1);
            return this.isLock(lockKey);
        }
        catch (JedisConnectionException je) {
            log.error("error connection so reconnect / get key[{}]", (Object)lockKey, (Object)je);
            this.reconnect(1);
            return this.isLock(lockKey);
        }
        catch (Exception e) {
            log.error("fail call redis so return <null> ", (Throwable)e);
        }
        return result;
    }

    public <T extends Serializable> void putObjectToJson(String key, T value) throws Exception {
        try {
            this.vops.set((Object)key, (Object)JsonConvertUtil.objectToJsonString(value));
        }
        catch (RedisConnectionFailureException rfe) {
            log.error("error connection so reconnect / key[{}] value[{}]", new Object[]{key, value, rfe});
            this.reconnect(1);
            this.putObjectToJson(key, value);
        }
        catch (JedisConnectionException je) {
            log.error("error connection so reconnect / key[{}] value[{}]", new Object[]{key, value, je});
            this.reconnect(1);
            this.putObjectToJson(key, value);
        }
        catch (Exception e) {
            throw e;
        }
    }

    public <T extends Serializable> T getJsonToObject(String key, Class<T> clazz) throws Exception {
        String jsonString = (String)this.vops.get((Object)key);
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        return JsonConvertUtil.jsonStringToObject(jsonString, clazz);
    }

    public <T extends Serializable> void getJsonToObject(String key, Class<T> clazz, Map<String, T> m) throws Exception {
        Map maps = this.stringHops.entries((Object)key);
        if (ObjectUtils.isEmpty((Object)maps)) {
            return;
        }
        for (String k : maps.keySet()) {
            m.put(k, JsonConvertUtil.jsonStringToObject((String)maps.get(k), clazz));
        }
    }

    public <T extends Serializable> void putObjectToJson(String key, String field, T value) throws Exception {
        try {
            this.stringHops.put((Object)key, (Object)field, (Object)JsonConvertUtil.objectToJsonString(value));
        }
        catch (RedisConnectionFailureException rfe) {
            log.error("error connection so reconnect / key[{}] value[{}]", new Object[]{key, value, rfe});
            this.reconnect(1);
            this.putObjectToJson(key, field, value);
        }
        catch (JedisConnectionException je) {
            log.error("error connection so reconnect / key[{}] value[{}]", new Object[]{key, value, je});
            this.reconnect(1);
            this.putObjectToJson(key, field, value);
        }
        catch (Exception e) {
            throw e;
        }
    }

    public <T extends Serializable> T getJsonToObject(String key, String field, Class<T> clazz) throws Exception {
        String jsonString = (String)this.stringHops.get((Object)key, (Object)field);
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        return JsonConvertUtil.jsonStringToObject(jsonString, clazz);
    }

    public static void main(String[] args) {
        System.out.println("CRSLT:EM:202005211542".substring(9));
    }
}

