/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.redis;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.TmsCommonConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.GenericToStringSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
@ConditionalOnProperty(prefix="spring.redis.sentinel", name={"nodes"})
public class SentinelRedisConfig {
    @Value(value="${spring.redis.sentinel.nodes}")
    String sentinelHosts;
    @Value(value="${spring.redis.sentinel.master}")
    String sentinelMaster;
    @Value(value="${spring.redis.pool.max-active:100}")
    int maxActive;
    @Value(value="${spring.redis.pool.max-idle:30}")
    int maxIdle;
    @Value(value="${spring.redis.pool.min-idle:5}")
    int minIdle;
    @Autowired
    TmsCommonConfig tmsConfig;
    RedisSentinelConfiguration sentinelConfig;

    @Bean
    public RedisConnectionFactory jedisConnectionFactory() {
        String[] hostArray;
        this.sentinelConfig = new RedisSentinelConfiguration().master(this.sentinelMaster);
        for (String hostAndPort : hostArray = this.sentinelHosts.split(",")) {
            String[] hostAndPortArray = hostAndPort.split(":");
            this.sentinelConfig.sentinel(hostAndPortArray[0].trim(), Integer.valueOf(Integer.parseInt(hostAndPortArray[1].trim())));
        }
        JedisConnectionFactory jcf = new JedisConnectionFactory(this.sentinelConfig);
        jcf.setPoolConfig(this.jedisPoolConfig());
        jcf.setClientName(this.tmsConfig.getEngine() + this.tmsConfig.getNode());
        return jcf;
    }

    @Bean
    public WrapperRedisTemplate wrapperRedisTemplate() {
        return new WrapperRedisTemplate();
    }

    public RedisConnectionFactory singleJedisConnectionFactory() {
        JedisConnectionFactory jedisConnectionFactory = new JedisConnectionFactory(this.sentinelConfig);
        jedisConnectionFactory.setClientName(this.tmsConfig.getEngine() + this.tmsConfig.getNode());
        jedisConnectionFactory.afterPropertiesSet();
        return jedisConnectionFactory;
    }

    private JedisPoolConfig jedisPoolConfig() {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(this.maxActive);
        poolConfig.setMaxIdle(this.maxIdle);
        poolConfig.setMinIdle(this.minIdle);
        poolConfig.setTestOnBorrow(true);
        poolConfig.setLifo(false);
        return poolConfig;
    }

    @Bean
    public StringRedisTemplate stringRedisTemplate() {
        StringRedisTemplate redisTemplate = new StringRedisTemplate();
        redisTemplate.setConnectionFactory(this.jedisConnectionFactory());
        redisTemplate.setValueSerializer((RedisSerializer)new GenericToStringSerializer(Object.class));
        return redisTemplate;
    }

    public StringRedisTemplate singleStringRedisTemplate() {
        StringRedisTemplate redisTemplate = new StringRedisTemplate();
        JedisConnectionFactory jcf = new JedisConnectionFactory(this.sentinelConfig);
        jcf.setClientName(this.tmsConfig.getEngine() + this.tmsConfig.getNode());
        redisTemplate.setValueSerializer((RedisSerializer)new GenericToStringSerializer(Object.class));
        redisTemplate.setConnectionFactory((RedisConnectionFactory)jcf);
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }

    public void singleClose(WrapperRedisTemplate wrapperRedisTemplate) {
        wrapperRedisTemplate.close();
    }

    public RedisSentinelConfiguration sentinelConfig() {
        return this.sentinelConfig;
    }
}

