/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.redis;

import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ObjectUtils;

@Configuration
@ConditionalOnProperty(prefix="spring.redis.sentinel", name={"nodes"})
public class RedissonAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RedissonAutoConfiguration.class);
    @Autowired
    private RedisProperties redisProperties;
    @Value(value="${spring.redis.sentinel.master}")
    private String master;
    @Value(value="${spring.redis.pool.max-active:100}")
    private int maxActive;
    @Value(value="${spring.redis.pool.max-idle:30}")
    private int maxIdle;
    @Value(value="${spring.redis.pool.min-idle:5}")
    private int minIdle;
    @Value(value="${spring.redis.timeout:10000}")
    private int redisTimeout;

    @Bean
    public RedissonClient redissonClient() {
        if (ObjectUtils.isEmpty((Object)this.redisProperties)) {
            return null;
        }
        Config config = new Config();
        if (this.redisProperties.getSentinel() != null) {
            log.info("Redis Sentinel connecting... nodes[{}]", (Object)this.redisProperties.getSentinel().getNodes());
            SentinelServersConfig sentinelServersConfig = config.useSentinelServers();
            sentinelServersConfig.setMasterName(this.redisProperties.getSentinel().getMaster());
            String[] addresses = this.redisProperties.getSentinel().getNodes().split(",");
            String[] prefixAddresses = new String[addresses.length];
            for (int i = 0; i < prefixAddresses.length; ++i) {
                prefixAddresses[i] = "redis://" + addresses[i];
            }
            sentinelServersConfig.addSentinelAddress(prefixAddresses);
            sentinelServersConfig.setDatabase(this.redisProperties.getDatabase());
            sentinelServersConfig.setTimeout(this.redisTimeout);
            if (this.redisProperties.getPassword() != null) {
                sentinelServersConfig.setPassword(this.redisProperties.getPassword());
            }
        } else {
            SingleServerConfig singleServerConfig = config.useSingleServer();
            String schema = this.redisProperties.isSsl() ? "rediss://" : "redis://";
            singleServerConfig.setAddress(schema + this.redisProperties.getHost() + ":" + this.redisProperties.getPort());
            singleServerConfig.setDatabase(this.redisProperties.getDatabase());
            if (this.redisProperties.getPassword() != null) {
                singleServerConfig.setPassword(this.redisProperties.getPassword());
            }
            singleServerConfig.setTimeout(this.redisTimeout);
        }
        return Redisson.create((Config)config);
    }
}

