/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.redis;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum CrsltKeyRepository {
    INSTANCE;

    private static final Logger log;
    private static final Set<String> crsltKeys;
    private static final String yyyyMMddHHmm = "yyyyMMddHHmm";
    private static final DateTimeFormatter CRSLT_DATE_FORMAT;

    private CrsltKeyRepository() {
        new Thread(){

            @Override
            public void run() {
                Iterator iter = crsltKeys.iterator();
                while (iter.hasNext()) {
                    try {
                        String crsltKey = (String)iter.next();
                        if (crsltKey.length() != 21) {
                            log.error("this CRSLT key is not 21 length. so skip.. key[{}]", (Object)crsltKey);
                            continue;
                        }
                        String dateTimeOfKey = crsltKey.substring(9);
                        LocalDateTime dateTime = LocalDateTime.parse(dateTimeOfKey, CRSLT_DATE_FORMAT);
                        if (LocalDateTime.now().minusDays(3L).isAfter(dateTime)) {
                            crsltKeys.remove(crsltKey);
                        }
                        Thread.sleep(3600000L);
                    }
                    catch (Exception e) {
                        log.error("thread interrupt error", (Throwable)e);
                    }
                }
            }
        }.start();
    }

    public boolean setCrsltKey(String key) {
        boolean contains = crsltKeys.contains(key);
        if (contains) {
            return false;
        }
        crsltKeys.add(key);
        return true;
    }

    static {
        log = LoggerFactory.getLogger(CrsltKeyRepository.class);
        crsltKeys = new HashSet<String>();
        CRSLT_DATE_FORMAT = DateTimeFormatter.ofPattern(yyyyMMddHHmm);
    }
}

