/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.jdbc.mybatis.type;

import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.springframework.util.ObjectUtils;

@MappedTypes(value={Date.class})
@MappedJdbcTypes(value={JdbcType.CHAR})
public class DateStringOnlyOracleTypeHandler
extends BaseTypeHandler<String> {
    public String getNullableResult(ResultSet resultSet, String s) throws SQLException {
        return this.getTransToStringFromDate(resultSet.getDate(s));
    }

    public String getNullableResult(ResultSet resultSet, int i) throws SQLException {
        return this.getTransToStringFromDate(resultSet.getDate(i));
    }

    public String getNullableResult(CallableStatement callableStatement, int i) throws SQLException {
        return this.getTransToStringFromDate(callableStatement.getDate(i));
    }

    private String getTransToStringFromDate(Date s) {
        if (s == null) {
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.format(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void setNonNullParameter(PreparedStatement ps, int i, String parameter, JdbcType jdbcType) throws SQLException {
        if (ObjectUtils.isEmpty((Object)parameter)) {
            ps.setDate(i, null);
        } else {
            Date sqlDate = Date.valueOf(parameter);
            ps.setDate(i, sqlDate);
        }
    }
}

