/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.jdbc.mybatis.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;

@MappedTypes(value={Boolean.class})
@MappedJdbcTypes(value={JdbcType.CHAR})
public class BooleanStringTypeHandler
extends BaseTypeHandler {
    public Boolean getNullableResult(ResultSet resultSet, String s) throws SQLException {
        return this.getBoolean(resultSet.getString(s));
    }

    public Boolean getNullableResult(ResultSet resultSet, int i) throws SQLException {
        return this.getBoolean(resultSet.getString(i));
    }

    public Boolean getNullableResult(CallableStatement callableStatement, int i) throws SQLException {
        return this.getBoolean(callableStatement.getString(i));
    }

    private Boolean getBoolean(String s) {
        if (s == null) {
            return null;
        }
        return "Y".equalsIgnoreCase(s);
    }

    public void setNonNullParameter(PreparedStatement ps, int i, Object parameter, JdbcType jdbcType) throws SQLException {
        if (parameter != null) {
            ps.setString(i, (Boolean)parameter != false ? "Y" : "N");
        } else {
            ps.setString(i, "N");
        }
    }
}

