/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.jdbc.mybatis.builder;

import java.util.Map;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.batch.MyBatisPagingItemReader;

public class MyBatisPagingItemReaderBuilder<T> {
    private SqlSessionFactory sqlSessionFactory;
    private String queryId;
    private Map<String, Object> parameterValues;
    private Integer pageSize;
    private Boolean saveState;
    private Integer maxItemCount;

    public MyBatisPagingItemReaderBuilder<T> sqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
        return this;
    }

    public MyBatisPagingItemReaderBuilder<T> queryId(String queryId) {
        this.queryId = queryId;
        return this;
    }

    public MyBatisPagingItemReaderBuilder<T> parameterValues(Map<String, Object> parameterValues) {
        this.parameterValues = parameterValues;
        return this;
    }

    public MyBatisPagingItemReaderBuilder<T> pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public MyBatisPagingItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public MyBatisPagingItemReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public MyBatisPagingItemReader<T> build() {
        MyBatisPagingItemReader reader = new MyBatisPagingItemReader();
        reader.setSqlSessionFactory(this.sqlSessionFactory);
        reader.setQueryId(this.queryId);
        reader.setParameterValues(this.parameterValues);
        if (this.pageSize != null) {
            reader.setPageSize(this.pageSize.intValue());
        }
        if (this.saveState != null) {
            reader.setSaveState(this.saveState.booleanValue());
        }
        if (this.maxItemCount != null) {
            reader.setMaxItemCount(this.maxItemCount.intValue());
        }
        return reader;
    }
}

