/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.jdbc.mybatis;

import com.google.common.collect.Lists;
import com.humuson.tms.adaptor.jdbc.BizSqlException;
import com.humuson.tms.adaptor.jdbc.LinkedHashMapRowMapperExecutor;
import com.humuson.tms.adaptor.jdbc.MapRowMapperExecutor;
import com.humuson.tms.adaptor.jdbc.TmsBatchDataSourceManager;
import com.humuson.tms.adaptor.jdbc.TmsRowMapperExecutor;
import com.humuson.tms.adaptor.jdbc.mybatis.MapperedDataTokenHandler;
import com.humuson.tms.adaptor.jdbc.mybatis.TmsJdbcError;
import com.humuson.tms.util.Pair;
import com.zaxxer.hikari.HikariDataSource;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.ibatis.parsing.TokenHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.ObjectUtils;

public class TmsJdbcTemplate {
    private static final Logger log = LoggerFactory.getLogger(TmsJdbcTemplate.class);
    private Status status;
    JdbcTemplate jdbcTemplate;
    @Value(value="${adaptor.move.from.chunk-count:1000}")
    private int batchExecutorCount = 1000;
    static final String DEFAULT_MAPPING_KEY = "${";
    static final String DEFAULT_CLOSE_CODE = "}";
    static final String SINGLE_QUTATION = "'";
    static final String SINGLE_QUTATION_CLOSE = "}'";
    boolean addOnSingleQuatation;
    boolean multiOpenCode = false;
    boolean onlyOnceQuery = false;
    Charset charset;
    private HikariDataSource dataSource = null;
    private List<TmsJdbcError> errorDatas = null;

    public void setFetchSize(int fetchsize) {
        this.jdbcTemplate.setFetchSize(fetchsize);
    }

    public TmsJdbcTemplate setUnmappedSql(String sql) {
        return this;
    }

    public TmsJdbcTemplate setAllInOne(boolean one) {
        return this;
    }

    public TmsJdbcTemplate setIndividualCount(int count) {
        return this;
    }

    public TmsJdbcTemplate setCommitCount(int count) {
        return this;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public TmsJdbcTemplate db(int dbId, boolean isMaintain) throws Exception {
        return this.db(TmsBatchDataSourceManager.INSTANCE.getDataSource(dbId, isMaintain));
    }

    public TmsJdbcTemplate db(int dbId) throws Exception {
        return this.db(dbId, false);
    }

    public TmsJdbcTemplate db(Map<String, Object> map) throws Exception {
        return this.db(TmsBatchDataSourceManager.INSTANCE.getDataSource(map));
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public TmsJdbcTemplate db(String url, String driver, String user, String pass) {
        this.status = Status.CLOSE;
        try {
            this.status = Status.CONNECTING;
            this.db(TmsBatchDataSourceManager.INSTANCE.getDataSource(url, driver, user, pass));
        }
        catch (Exception e) {
            log.error("error create datasource", (Throwable)e);
        }
        return this;
    }

    public TmsJdbcTemplate db(DataSource dataSource) {
        this.dataSource = (HikariDataSource)dataSource;
        this.status = Status.CLOSE;
        try {
            this.status = Status.CONNECTING;
            this.jdbcTemplate = new JdbcTemplate((DataSource)this.dataSource);
        }
        catch (Exception e) {
            log.error("error create datasource", (Throwable)e);
        }
        return this;
    }

    public void close() {
        try {
            if (this.errorDatas != null) {
                this.errorDatas.clear();
            }
            if (this.dataSource instanceof HikariDataSource) {
                TmsBatchDataSourceManager.INSTANCE.destory((DataSource)this.dataSource);
            } else {
                this.dataSource.getConnection().close();
            }
        }
        catch (Exception e) {
            log.error("error connection closing ", (Throwable)e);
        }
    }

    public void destroy() {
        this.close();
    }

    private boolean hikariDatasourceClose(HikariDataSource ds) {
        try {
            if (ds == null) {
                return true;
            }
            if (ds.isClosed()) {
                ds = null;
            } else {
                ds.close();
            }
        }
        catch (Exception e) {
            log.error("don't closed hikari datasource. pool name[{}]", (Object)ds.getPoolName(), (Object)e);
            return false;
        }
        return ds.isClosed();
    }

    public List<TmsJdbcError> getErrorDatas() {
        return this.errorDatas;
    }

    public boolean setFromFile(String fullPathFileName) {
        return false;
    }

    public Map<String, Object> selectOne(String sql) {
        return this.selectOnlyOne(sql);
    }

    private Map<String, Object> beanToMap(Object value) {
        if (value == null) {
            return new HashMap<String, Object>();
        }
        if (!(value instanceof Map)) {
            return TmsJdbcTemplate.convertObjectToMap(value);
        }
        return (Map)value;
    }

    public static Map ConverObjectToMap(Object obj) {
        try {
            Field[] fields = obj.getClass().getDeclaredFields();
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            for (int i = 0; i <= fields.length - 1; ++i) {
                fields[i].setAccessible(true);
                resultMap.put(fields[i].getName(), fields[i].get(obj));
            }
            return resultMap;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException el) {
            el.printStackTrace();
        }
        return null;
    }

    public static Map<String, Object> convertObjectToMap(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Method[] methods;
            Class<?> pomclass = obj.getClass();
            pomclass = obj.getClass();
            for (Method m : methods = obj.getClass().getMethods()) {
                Object value;
                if (m.getName().startsWith("get") && !m.getName().startsWith("getClass")) {
                    value = m.invoke(obj, new Object[0]);
                    map.put(m.getName().substring(3), value);
                    continue;
                }
                if (!m.getName().startsWith("is") || m.getName().startsWith("getClass")) continue;
                value = m.invoke(obj, new Object[0]);
                map.put(m.getName().substring(2), value);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            log.error("error bean[{}] to map change. return null", obj, (Object)e);
            return null;
        }
        if (map.isEmpty()) {
            log.error("failed convert object[{}] to map, map is empty", obj);
        }
        return map;
    }

    public <T> T queryForObject(String sql, Class<T> requiredType) {
        return (T)this.jdbcTemplate.queryForObject(sql, requiredType);
    }

    public Map<String, Object> selectOne(String sql, Object value) {
        if (this.isEmpty(sql, value)) {
            return null;
        }
        Map<String, Object> map = this.beanToMap(value);
        String openCode = this.detectMappingKey(sql);
        boolean addSingleQuatation = !this.isExistSingleQutationInSql(sql);
        return this.selectOne(openCode, DEFAULT_CLOSE_CODE, sql, map, addSingleQuatation);
    }

    private Map<String, Object> selectOne(String startKey, String endKey, String sql, Map<String, Object> map, boolean addOnSingleQuatation) {
        MapperedDataTokenHandler mapperedDataTokenHandler = new MapperedDataTokenHandler();
        mapperedDataTokenHandler.setToken(startKey, endKey, new JdbcTokenHandler(map, addOnSingleQuatation), true);
        String mapperedQuery = mapperedDataTokenHandler.parse(sql);
        mapperedDataTokenHandler.clear();
        if (log.isDebugEnabled()) {
            log.debug("orginal query[{}] \nmapping query[{}]", (Object)sql, (Object)mapperedQuery);
        }
        return this.selectOnlyOne(mapperedQuery);
    }

    public <T> T selectOne(String sql, Object value, Class<T> resultType) {
        if (this.isEmpty(sql, value)) {
            return null;
        }
        String mapperedQuery = this.selectMapperedSql(sql, value);
        return this.mapToBean(resultType, this.selectOnlyOne(mapperedQuery));
    }

    private String selectMapperedSql(String sql, Object value) {
        Map<String, Object> map = this.beanToMap(value);
        String openCode = this.detectMappingKey(sql);
        boolean addSingleQuatation = !this.isExistSingleQutationInSql(sql);
        MapperedDataTokenHandler mapperedDataTokenHandler = new MapperedDataTokenHandler();
        mapperedDataTokenHandler.setToken(openCode, DEFAULT_CLOSE_CODE, new JdbcTokenHandler(map, addSingleQuatation), true);
        String mapperedQuery = mapperedDataTokenHandler.parse(sql);
        if (log.isDebugEnabled()) {
            log.debug("org SQL[{}] \nmappered SQL[{}]", (Object)sql, (Object)mapperedQuery);
        }
        mapperedDataTokenHandler.clear();
        return mapperedQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> selectOnlyOne(String mapperedQuery) {
        try {
            List results = this.jdbcTemplate.query(mapperedQuery, (RowMapper)new MapRowMapperExecutor(false));
            if (ObjectUtils.isEmpty((Object)results)) {
                Map<String, Object> map = null;
                return map;
            }
            Map map = (Map)results.get(0);
            return map;
        }
        catch (BadSqlGrammarException ex) {
            log.warn("this query is bad sql grammar. return null. SQL[{}]", (Object)ex.getMessage(), (Object)mapperedQuery);
            Map<String, Object> map = null;
            return map;
        }
        catch (EmptyResultDataAccessException ee) {
            log.warn("query {} so return null. SQL[{}]", (Object)ee.getMessage(), (Object)mapperedQuery);
            Map<String, Object> map = null;
            return map;
        }
        catch (IncorrectResultSizeDataAccessException e) {
            log.error("if the query does not return exactly one row over. \nso return null SQL[{}]", (Object)mapperedQuery, (Object)e);
            Map<String, Object> map = null;
            return map;
        }
        finally {
            if (this.onlyOnceQuery) {
                this.close();
            }
        }
    }

    public void setOnceQueryClose(boolean onlyOnceQuery) {
        this.onlyOnceQuery = onlyOnceQuery;
    }

    private String detectMappingKey(String sql) {
        if (sql.contains(DEFAULT_MAPPING_KEY)) {
            return DEFAULT_MAPPING_KEY;
        }
        if (sql.contains("@{")) {
            return "@{";
        }
        if (sql.contains("#{")) {
            return "#{";
        }
        return DEFAULT_MAPPING_KEY;
    }

    private boolean isExistSingleQutationInSql(String sql) {
        return sql.contains("'${") || sql.contains("'@{") || sql.contains("'#{");
    }

    private boolean isEmpty(Object ... values) {
        for (Object obj : values) {
            if (!(obj instanceof String ? obj.toString().isEmpty() : obj == null)) continue;
            return true;
        }
        return false;
    }

    public <T> T selectOne(String sql, Class<T> resultType) {
        return (T)this.jdbcTemplate.queryForObject(sql, resultType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List selectList(String sql, TmsRowMapperExecutor tmsExecutor) {
        try {
            List list = this.jdbcTemplate.query(sql, (RowMapper)tmsExecutor);
            return list;
        }
        finally {
            if (this.onlyOnceQuery) {
                this.close();
            }
        }
    }

    public List<Map<String, Object>> selectList(String sql) {
        try {
            List list = this.jdbcTemplate.query(sql, (RowMapper)new MapRowMapperExecutor(false));
            return list;
        }
        finally {
            if (this.onlyOnceQuery) {
                this.close();
            }
        }
    }

    public List<LinkedHashMap<String, Object>> selectListLinkedHashMap(String sql) {
        try {
            List list = this.jdbcTemplate.query(sql, (RowMapper)new LinkedHashMapRowMapperExecutor(false){

                @Override
                protected void execute(LinkedHashMap<String, Object> result) throws BizSqlException {
                }

                @Override
                protected void columnMapping(LinkedHashMap<String, Object> mapper, String columnLabel, Object value) {
                }

                @Override
                protected LinkedHashMap<String, Object> execute(Map<String, Object> result) throws BizSqlException {
                    return null;
                }

                @Override
                protected void columnMapping(Map<String, Object> mapper, String columnLabel, Object value) {
                }
            });
            return list;
        }
        finally {
            if (this.onlyOnceQuery) {
                this.close();
            }
        }
    }

    public List<Map<String, Object>> selectListOptNullToEmpty(String sql) {
        try {
            List list = this.jdbcTemplate.query(sql, (RowMapper)new MapRowMapperExecutor(true){

                @Override
                protected void columnMapping(Map<String, Object> mapper, String columnLabel, Object value) {
                    mapper.put(columnLabel, value == null ? "" : value);
                }
            });
            return list;
        }
        finally {
            if (this.onlyOnceQuery) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> selectList(String sql, Object value) {
        if (this.isEmpty(sql, value)) {
            return null;
        }
        String mapperedQuery = this.selectMapperedSql(sql, value);
        try {
            List list = this.jdbcTemplate.queryForList(mapperedQuery, new Object[]{new MapRowMapperExecutor(false)});
            return list;
        }
        finally {
            if (this.onlyOnceQuery) {
                this.close();
            }
        }
    }

    public <T> List<T> selectBeanList(String sql, Object mapper, Class<T> resultType) {
        List<Map<String, Object>> queryResultList = this.selectList(sql, mapper);
        ArrayList<T> resultBeanList = new ArrayList<T>();
        for (Map<String, Object> map : queryResultList) {
            resultBeanList.add(this.mapToBean(resultType, map));
        }
        if (!queryResultList.isEmpty() && resultBeanList.isEmpty()) {
            log.error("failed List<Map> count[{}] to List<Bean> count[0] change error", (Object)queryResultList.size());
            return null;
        }
        return resultBeanList;
    }

    private <T> T mapToBean(Class<T> resultType, Map<String, Object> map) {
        try {
            T t = resultType.newInstance();
            BeanUtils.populate(t, map);
            return t;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("map[{}] to bean[{}] change error. next continue..", map, (Object)resultType.getName());
            return null;
        }
        catch (InstantiationException e) {
            log.error("create new Instance error. \nmap[{}] to bean[{}] next continue..", map, (Object)resultType.getName());
            e.printStackTrace();
            return null;
        }
    }

    public static final int[] merge(int[] ... arrays) {
        int size = 0;
        for (int[] a : arrays) {
            size += a.length;
        }
        int[] res = new int[size];
        int destPos = 0;
        for (int i = 0; i < arrays.length; ++i) {
            if (i > 0) {
                destPos += arrays[i - 1].length;
            }
            int length = arrays[i].length;
            System.arraycopy(arrays[i], 0, res, destPos, length);
        }
        return res;
    }

    public int update(String sql) {
        return this.jdbcTemplate.update(sql);
    }

    public int update(String sql, Object value) {
        if (this.isEmpty(sql, value)) {
            return 0;
        }
        return this.jdbcTemplate.update(this.selectMapperedSql(sql, value));
    }

    public int[] updateBatch(String sql, Object mapper, List<? extends Object> values, String preStartMapperKey) throws Exception {
        String mapperedQuery = this.preMappingSql(sql, mapper, preStartMapperKey);
        return this.updateBatch(mapperedQuery, values);
    }

    public String preMappingSql(String sql, Object mapper, String preStartMapperKey) {
        if (this.isEmpty(sql, mapper)) {
            return null;
        }
        Map<String, Object> map = this.beanToMap(mapper);
        MapperedDataTokenHandler mapperedDataTokenHandler = new MapperedDataTokenHandler();
        mapperedDataTokenHandler.setToken(preStartMapperKey, DEFAULT_CLOSE_CODE, new JdbcTokenHandler(map, false), true);
        String mapperedQuery = mapperedDataTokenHandler.parse(sql);
        mapperedDataTokenHandler.clear();
        if (log.isDebugEnabled()) {
            log.debug("one step['${'] mappered query[{}]", (Object)mapperedQuery);
        }
        return mapperedQuery;
    }

    @Deprecated
    public int[] updateBatch(String sql, List<? extends Object> values) throws Exception {
        if (this.isEmpty(sql, values)) {
            return null;
        }
        ArrayList resultList = new ArrayList();
        if (values.size() > this.batchExecutorCount) {
            List<List<Object>> objList = this.split(values);
            int[][] arrayResult = new int[objList.size()][];
            for (int i = 0; i < objList.size(); ++i) {
                arrayResult[i] = this.updateBatchDistribute(sql, objList.get(i));
            }
            return TmsJdbcTemplate.merge(arrayResult);
        }
        return this.updateBatchDistribute(sql, values);
    }

    public int[] updateBatchDistribute(String sql, List<? extends Object> values) throws Exception {
        if (values == null || values.isEmpty()) {
            log.error("update data is empty. return null sql[{}]", (Object)sql);
            return null;
        }
        HashMap<Integer, Integer> orgRepository = new HashMap<Integer, Integer>();
        MapperedDataTokenHandler mapperedDataTokenHandler = new MapperedDataTokenHandler();
        try {
            String tmpSql = sql;
            if (this.isExistSingleQutationInSql(sql)) {
                sql = this.singleQutationMapping(sql, mapperedDataTokenHandler);
            }
            mapperedDataTokenHandler.setToken(this.detectMappingKey(sql), DEFAULT_CLOSE_CODE, !tmpSql.equals(sql));
            String mappingSql = mapperedDataTokenHandler.parse(sql);
            if (log.isDebugEnabled()) {
                log.debug("preparead mappered query[{}]", (Object)mappingSql);
            }
            ArrayList<Map<String, Object>> tempMapList = new ArrayList<Map<String, Object>>();
            for (int i = 0; i < values.size(); ++i) {
                Object obj = values.get(i);
                if (obj instanceof Map) continue;
                tempMapList.add(TmsJdbcTemplate.convertObjectToMap(obj));
            }
            List<Object[]> objList = null;
            Pair<List<Object[]>, int[]> pair = null;
            if (tempMapList.isEmpty()) {
                pair = mapperedDataTokenHandler.mapping1(values, true, orgRepository);
                objList = pair.getFirst();
                if (log.isDebugEnabled()) {
                    this.mappingDataLog(values, objList);
                }
            } else {
                pair = mapperedDataTokenHandler.mapping1(tempMapList, true, orgRepository);
                objList = pair.getFirst();
                if (log.isDebugEnabled()) {
                    this.mappingDataLog(tempMapList, objList);
                }
            }
            try {
                return this.batchUpdateOfJdbcTemplate(mappingSql, objList, pair.getSecond());
            }
            catch (BadSqlGrammarException ex) {
                throw ex;
            }
            catch (Exception e) {
                try {
                    log.error("batch update error so single step update sql[{}], obj list size[{}]", new Object[]{mappingSql, objList.size(), e});
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                this.errorDatas = new ArrayList<TmsJdbcError>();
                int[] count = new int[objList.size()];
                for (int i = 0; i < objList.size(); ++i) {
                    try {
                        count[i] = this.jdbcTemplate.update(mappingSql, objList.get(i));
                        continue;
                    }
                    catch (Exception e2) {
                        TmsJdbcError error = new TmsJdbcError();
                        log.error("single update error count[{}]. continue.. \nsql[{}] \nmapper[{}] error:{}", new Object[]{i, mappingSql, objList.get(i), e2.getMessage()});
                        Integer orgHashCode = (Integer)orgRepository.get(objList.get(i).hashCode());
                        if (tempMapList.isEmpty()) {
                            error.setMappingInfo(this.searchOrgData(orgHashCode, values));
                        } else {
                            error.setMappingInfo(this.searchOrgData(orgHashCode, tempMapList));
                        }
                        error.setException(e2);
                        this.errorDatas.add(error);
                    }
                }
                return count;
            }
        }
        catch (Exception e) {
            log.error("error return", (Throwable)e);
            mapperedDataTokenHandler.clear();
            if (e instanceof BadSqlGrammarException) {
                throw e;
            }
            return null;
        }
    }

    public int[] batchUpdateOfJdbcTemplate(final String sql, final List<Object[]> O, final int[] argTypes) {
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setPropagationBehavior(3);
        transactionDefinition.setIsolationLevel(2);
        DataSourceTransactionManager dataSourceTransactionManager = new DataSourceTransactionManager((DataSource)this.dataSource);
        dataSourceTransactionManager.setNestedTransactionAllowed(true);
        dataSourceTransactionManager.setValidateExistingTransaction(true);
        return (int[])new TransactionTemplate((PlatformTransactionManager)dataSourceTransactionManager, (TransactionDefinition)transactionDefinition).execute((TransactionCallback)new TransactionCallback<int[]>(){

            public int[] doInTransaction(TransactionStatus status) {
                int[] result = argTypes == null ? TmsJdbcTemplate.this.jdbcTemplate.batchUpdate(sql, O) : TmsJdbcTemplate.this.jdbcTemplate.batchUpdate(sql, O, argTypes);
                O.clear();
                return result;
            }
        });
    }

    public int[] batchUpdateOfJdbcTemplate(String sql, List<Object[]> O) {
        return this.batchUpdateOfJdbcTemplate(sql, O, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] batchUpdateOldWay(String sql, List<Object[]> O, int[] argTypes) {
        PreparedStatement prepared = null;
        try {
            Object[] os;
            prepared = this.dataSource.getConnection().prepareStatement(sql);
            prepared.clearParameters();
            for (int i = 0; i < O.size(); ++i) {
                os = O.get(i);
                int idx = 1;
                for (int j = 0; j < argTypes.length; ++j) {
                    switch (argTypes[j]) {
                        case 4: {
                            prepared.setInt(idx, (Integer)os[j]);
                            break;
                        }
                        case 2: {
                            prepared.setLong(idx, (Long)os[j]);
                            break;
                        }
                        case 0: {
                            prepared.setNull(idx, 0);
                            break;
                        }
                        default: {
                            prepared.setString(idx, os[j].toString());
                        }
                    }
                    ++idx;
                }
                prepared.addBatch();
            }
            System.out.println("START BATCH COMMIT");
            int[] results = prepared.executeBatch();
            System.out.println("END BATCH COMMIT");
            os = results;
            return os;
        }
        catch (Exception e) {
            try {
                log.error("batch query[{}] execute error so rollback", (Object)sql, (Object)e);
            }
            catch (Exception e2) {
                log.error("query[{}] roll back error", (Object)sql, (Object)e2);
            }
        }
        return null;
    }

    public Pair<List<Object[]>, int[]> mapping(String sql, List<? extends Object> values) throws Exception {
        if (values == null || values.isEmpty()) {
            log.error("update data is empty. return null sql[{}]", (Object)sql);
            return null;
        }
        HashMap<Integer, Integer> orgRepository = new HashMap<Integer, Integer>();
        MapperedDataTokenHandler mapperedDataTokenHandler = new MapperedDataTokenHandler();
        String tmpSql = sql;
        if (this.isExistSingleQutationInSql(sql)) {
            sql = this.singleQutationMapping(sql, mapperedDataTokenHandler);
        }
        mapperedDataTokenHandler.setToken(this.detectMappingKey(sql), DEFAULT_CLOSE_CODE, !tmpSql.equals(sql));
        String mappingSql = mapperedDataTokenHandler.parse(sql);
        if (log.isDebugEnabled()) {
            log.debug("preparead mappered query[{}]", (Object)mappingSql);
        }
        ArrayList<Map<String, Object>> tempMapList = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < values.size(); ++i) {
            Object obj = values.get(i);
            if (obj instanceof Map) continue;
            tempMapList.add(TmsJdbcTemplate.convertObjectToMap(obj));
        }
        Pair<List<Object[]>, int[]> pair = null;
        List<Object[]> objList = null;
        if (tempMapList.isEmpty()) {
            pair = mapperedDataTokenHandler.mapping1(values, true, orgRepository);
            objList = mapperedDataTokenHandler.mapping(values, true, orgRepository);
            if (log.isDebugEnabled()) {
                this.mappingDataLog(values, objList);
            }
        } else {
            pair = mapperedDataTokenHandler.mapping1(tempMapList, true, orgRepository);
            objList = mapperedDataTokenHandler.mapping(tempMapList, true, orgRepository);
            if (log.isDebugEnabled()) {
                this.mappingDataLog(tempMapList, objList);
            }
        }
        pair.setFirst(objList);
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBatchForClob(String sql, List<? extends Object> values, List<String> clobColumnNames) throws Exception {
        MapperedDataTokenHandler mapperedDataTokenHandler = new MapperedDataTokenHandler();
        TokenHandler springJdbcHandler = new TokenHandler(){

            public String handleToken(String content) {
                return ":" + content;
            }
        };
        String firstMapperedSql = "";
        if (this.isExistSingleQutationInSql(sql)) {
            String openCode = SINGLE_QUTATION + this.detectMappingKey(sql);
            mapperedDataTokenHandler.setToken(openCode, SINGLE_QUTATION_CLOSE, springJdbcHandler, false);
            firstMapperedSql = mapperedDataTokenHandler.parse(sql);
        }
        mapperedDataTokenHandler.setToken(this.detectMappingKey(sql), DEFAULT_CLOSE_CODE, springJdbcHandler, !firstMapperedSql.equals(sql));
        String mappingSql = mapperedDataTokenHandler.parse(sql);
        if (log.isDebugEnabled()) {
            log.debug("preparead mappered query[{}]", (Object)mappingSql);
        }
        ArrayList<? extends Object> tempMapList = new ArrayList<Object>();
        for (int i = 0; i < values.size(); ++i) {
            Object obj = values.get(i);
            if (obj instanceof Map) continue;
            tempMapList.add(TmsJdbcTemplate.convertObjectToMap(obj));
        }
        HashMap<Integer, Integer> orgRepository = new HashMap<Integer, Integer>();
        Pair<List<Object[]>, MapSqlParameterSource[]> pair = mapperedDataTokenHandler.makeMapSqlParmeter(tempMapList.isEmpty() ? values : tempMapList, clobColumnNames, true, orgRepository);
        if (log.isDebugEnabled()) {
            this.mappingDataLog(tempMapList.isEmpty() ? values : tempMapList, pair.getFirst());
        }
        try {
            this.batchUpdateOfJdbcTemplate(mappingSql, pair.getSecond());
        }
        catch (BadSqlGrammarException ex) {
            throw ex;
        }
        catch (Exception e) {
            List<Object[]> objList = pair.getFirst();
            try {
                log.error("batch update error so single step update sql[{}], obj list size[{}]", new Object[]{mappingSql, objList.size(), e});
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            this.errorDatas = new ArrayList<TmsJdbcError>();
            NamedParameterJdbcTemplate jdbcTemplateObject = new NamedParameterJdbcTemplate(this.jdbcTemplate.getDataSource());
            int idx = 1;
            for (MapSqlParameterSource in : pair.getSecond()) {
                try {
                    jdbcTemplateObject.update(mappingSql, (SqlParameterSource)in);
                }
                catch (Exception e2) {
                    TmsJdbcError error = new TmsJdbcError();
                    log.error("single update error count[{}]. continue.. \nsql[{}] \nmapper[{}] error:{}", new Object[]{idx, mappingSql, in.getValues(), e2.getMessage()});
                    Integer orgHashCode = (Integer)orgRepository.get(in.hashCode());
                    if (tempMapList.isEmpty()) {
                        error.setMappingInfo(this.searchOrgData(orgHashCode, values));
                    } else {
                        error.setMappingInfo(this.searchOrgData(orgHashCode, tempMapList));
                    }
                    error.setException(e2);
                    this.errorDatas.add(error);
                }
                ++idx;
            }
        }
        finally {
            try {
                if (pair.getFirst() != null) {
                    pair.getFirst().clear();
                }
                mapperedDataTokenHandler = null;
            }
            catch (Exception exception) {}
        }
    }

    public void batchUpdateOfJdbcTemplate(String sql, MapSqlParameterSource[] mapSqlParams) {
        NamedParameterJdbcTemplate jdbcTemplateObject = new NamedParameterJdbcTemplate(this.jdbcTemplate.getDataSource());
        jdbcTemplateObject.batchUpdate(sql, (SqlParameterSource[])mapSqlParams);
    }

    private Map<String, Object> searchOrgData(Integer orgHashCode, List<? extends Object> values) {
        for (Object object : values) {
            if (orgHashCode.intValue() != ((Map)object).hashCode()) continue;
            return (Map)object;
        }
        return null;
    }

    private String singleQutationMapping(String sql) {
        boolean isSingleQutation = this.isExistSingleQutationInSql(sql);
        if (isSingleQutation) {
            return this.singleQutationMapping(sql, new MapperedDataTokenHandler());
        }
        return sql;
    }

    private String singleQutationMapping(String sql, MapperedDataTokenHandler mapperedDataTokenHandler) {
        String openCode = SINGLE_QUTATION + this.detectMappingKey(sql);
        mapperedDataTokenHandler.setToken(openCode, SINGLE_QUTATION_CLOSE);
        return mapperedDataTokenHandler.parse(sql);
    }

    private void mappingDataLog(List<? extends Object> values, List<Object[]> objList) {
        log.debug("== mapping data list size[{}] start ==", (Object)values.size());
        for (Object[] obj : objList) {
            log.debug("MAPPING DATA = {}", (Object)Arrays.toString(obj));
        }
        log.debug("== mapping data list end ==");
    }

    private List<List<Object>> split(List<? extends Object> values) {
        return Lists.partition(values, (int)this.batchExecutorCount);
    }

    public void errClear() {
        if (this.errorDatas != null) {
            this.errorDatas.clear();
        }
    }

    class JdbcTokenHandler
    implements TokenHandler {
        private final Map<String, Object> map;
        private final boolean addOnSingleQuatation;

        JdbcTokenHandler(Map<String, Object> map, boolean addOnSingleQuatation) {
            this.map = map;
            this.addOnSingleQuatation = addOnSingleQuatation;
        }

        public String handleToken(String content) {
            if (this.map.containsKey(content)) {
                if (log.isDebugEnabled()) {
                    log.debug("mapping key[{}] value[{}]", (Object)content, (Object)this.map.containsKey(content));
                }
                Object obj = this.map.get(content);
                if (this.addOnSingleQuatation) {
                    if (obj == null) {
                        return null;
                    }
                    return obj instanceof String ? TmsJdbcTemplate.SINGLE_QUTATION + obj.toString() + TmsJdbcTemplate.SINGLE_QUTATION : obj.toString();
                }
                return obj.toString();
            }
            if (log.isWarnEnabled()) {
                log.warn("There is no mapping key[{}]. so return blank mapping", (Object)content);
            }
            return "";
        }
    }

    static enum Status {
        CONNECTING,
        EXECUTING,
        TIME_OVER,
        CLOSING,
        CLOSE;

    }
}

