/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.jdbc.mybatis;

import com.humuson.tms.adaptor.jdbc.DBType;
import com.humuson.tms.adaptor.jdbc.DBTypeDetector;
import com.humuson.tms.adaptor.jdbc.TmsBatchDataSourceManager;
import com.humuson.tms.adaptor.jdbc.TmsCommonMapperProperty;
import com.humuson.tms.adaptor.jdbc.mybatis.TmsDataSourceProperties;
import com.humuson.tms.adaptor.jdbc.mybatis.TmsJdbcTemplate;
import com.humuson.tms.adaptor.jdbc.mybatis.type.BooleanStringTypeHandler;
import com.humuson.tms.adaptor.jdbc.mybatis.type.DateStringOnlyOracleTypeHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.ibatis.parsing.GenericTokenParser;
import org.apache.ibatis.parsing.TokenHandler;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.database.ExtendedConnectionDataSourceProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ObjectUtils;

public abstract class TmsDatabaseConfig {
    private static final Logger log = LoggerFactory.getLogger(TmsDatabaseConfig.class);
    public static final String DB_TYPE = "db-type";
    private DBType dbType;
    protected DataSource datasource;
    @Autowired(required=false)
    private TmsCommonMapperProperty[] tmsCommonMapperProperties;

    protected DataSource createDataSource(TmsDataSourceProperties dataSourceProperties) {
        BasicDataSource datasource = new BasicDataSource();
        datasource.setDriverClassName(dataSourceProperties.getDriverClassName());
        datasource.setUrl(dataSourceProperties.getUrl());
        datasource.setUsername(dataSourceProperties.getUsername());
        datasource.setPassword(dataSourceProperties.getPassword());
        datasource.setTestOnBorrow(dataSourceProperties.isTestOnBorrow());
        datasource.setValidationQuery(dataSourceProperties.getValidationQuery());
        datasource.setTestWhileIdle(dataSourceProperties.isTestWhileIdle());
        datasource.setMaxIdle(dataSourceProperties.getMaxIdle());
        datasource.setMaxTotal(dataSourceProperties.getMaxActive());
        this.setDefaultDatabaseType(dataSourceProperties.getDriverClassName());
        this.datasource = datasource;
        return datasource;
    }

    protected void setDefaultDatabaseType(String driverClassName) {
        this.dbType = DBTypeDetector.databaseType(driverClassName);
        log.info("this TMS local database [{}]", (Object)this.dbType.name());
    }

    public DBType getDbType() {
        return this.dbType;
    }

    public DataSource batchForProxyDataSource() {
        ExtendedConnectionDataSourceProxy dataSource = new ExtendedConnectionDataSourceProxy();
        dataSource.setDataSource(this.directLocalDataSource());
        return dataSource;
    }

    public DataSource directLocalDataSource() {
        return TmsBatchDataSourceManager.INSTANCE.getDataSource(-1);
    }

    public int getNumberActiveConnection() {
        return ((BasicDataSource)this.datasource).getNumActive();
    }

    protected SqlSessionFactory sqlSessionFactory(DataSource dataSource, ApplicationContext applicationContext, String mybatisXmlPath) throws Exception {
        SqlSessionFactoryBean sqlSessionFactoryBean = new SqlSessionFactoryBean();
        sqlSessionFactoryBean.setDataSource(dataSource);
        sqlSessionFactoryBean.setMapperLocations(applicationContext.getResources(this.mapping(mybatisXmlPath)));
        if (DBType.ORACLE == this.dbType) {
            sqlSessionFactoryBean.setTypeHandlers(new TypeHandler[]{new BooleanStringTypeHandler(), new DateStringOnlyOracleTypeHandler()});
        } else {
            sqlSessionFactoryBean.setTypeHandlers(new TypeHandler[]{new BooleanStringTypeHandler()});
        }
        if (!ObjectUtils.isEmpty((Object[])this.tmsCommonMapperProperties)) {
            for (TmsCommonMapperProperty tmsCommonMapperProperty : this.tmsCommonMapperProperties) {
                sqlSessionFactoryBean.setConfigurationProperties(tmsCommonMapperProperty.commonMapper());
            }
        }
        SqlSessionFactory factory = sqlSessionFactoryBean.getObject();
        factory.getConfiguration().setJdbcTypeForNull(JdbcType.NULL);
        return factory;
    }

    public SqlSessionFactory sqlSessionFactory(DataSource datasource, String configXmlFile, String mapperXmlFile) {
        SqlSessionFactory sqlSessionFactory = null;
        try {
            SqlSessionFactoryBean sqlSessionFactoryBean = new SqlSessionFactoryBean();
            sqlSessionFactoryBean.setDataSource(datasource);
            sqlSessionFactoryBean.setConfigLocation((Resource)new ClassPathResource(configXmlFile));
            sqlSessionFactoryBean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources(mapperXmlFile));
            sqlSessionFactory = sqlSessionFactoryBean.getObject();
        }
        catch (IOException ioe) {
            log.error("0005|sqlSessionFactory.setMapperLocations Mapper Path Not Found", (Throwable)ioe);
        }
        catch (Exception e) {
            log.error("0006|sqlSessionFactory Exception", (Throwable)e);
        }
        return sqlSessionFactory;
    }

    private String mapping(String mybatisXmlPath) {
        String type = this.dbType.name().toLowerCase();
        HashMap<String, String> t = new HashMap<String, String>();
        t.put(DB_TYPE, type);
        GenericTokenParser parser = new GenericTokenParser("{", "}", (TokenHandler)new VariableTokenHandler(t));
        String mappedxml = parser.parse(mybatisXmlPath);
        log.info("mybatis xml path info[{}]", (Object)mappedxml);
        return mappedxml;
    }

    @Bean
    @Scope(value="prototype")
    public TmsJdbcTemplate tmsJdbcTemplate() {
        return new TmsJdbcTemplate();
    }

    public SqlSessionTemplate sqlSessionTemplate(SqlSessionFactory sqlSessionFactory) throws Exception {
        return new SqlSessionTemplate(sqlSessionFactory);
    }

    public abstract DataSource dataSource();

    public static class VariableTokenHandler
    implements TokenHandler {
        private Map<String, String> variables = new HashMap<String, String>();

        public VariableTokenHandler(Map<String, String> variables) {
            this.variables = variables;
        }

        public String handleToken(String content) {
            return this.variables.get(content);
        }
    }
}

