/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.jdbc.mybatis;

import com.humuson.tms.crypto.HumusonDecryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Primary
@Configuration
@Qualifier(value="tmsDataSourceProperties")
@ConfigurationProperties(prefix="spring.datasource")
public class TmsDataSourceProperties
extends DataSourceProperties {
    private static final Logger log = LoggerFactory.getLogger(TmsDataSourceProperties.class);
    int maxActive = 20;
    int maxIdle = 20;
    boolean testOnBorrow;
    String validationQuery;
    boolean testWhileIdle = true;
    boolean exConnectionMaintain = false;
    int exMaxActive = 20;
    int exMinIdle = 1;

    public int getExMaxActive() {
        return this.exMaxActive;
    }

    public void setExMaxActive(int exMaxActive) {
        this.exMaxActive = exMaxActive;
    }

    public int getExMinIdle() {
        return this.exMinIdle;
    }

    public void setExMinIdle(int exMinIdle) {
        this.exMinIdle = exMinIdle;
    }

    public boolean isExConnectionMaintain() {
        return this.exConnectionMaintain;
    }

    public void setExConnectionMaintain(boolean exConnectionMaintain) {
        this.exConnectionMaintain = exConnectionMaintain;
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public void setTestWhileIdle(boolean testWaitWhileIdle) {
        this.testWhileIdle = testWaitWhileIdle;
    }

    public String getOrgPassword() {
        return super.getPassword();
    }

    public String getPassword() {
        String pwd = super.getPassword();
        try {
            return HumusonDecryptor.decrypt(pwd);
        }
        catch (Exception e) {
            log.error("pass tms decrypt error. so return config orginal data[{}]", (Object)pwd, (Object)e);
            return pwd;
        }
    }
}

