/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.jdbc.mybatis;

import com.humuson.tms.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.parsing.TokenHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.support.SqlLobValue;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
@ConditionalOnBean(name={"sqlSessionFacotry"})
public class MapperedDataTokenHandler {
    private static final Logger log = LoggerFactory.getLogger(MapperedDataTokenHandler.class);
    private List<String> mapperKeys = null;
    private String openToken = "@{";
    private String closeToken = "}";
    private TokenHandler tokenHandler;
    List<? extends Object> orgTarget;

    public void setToken(String openToken, String closeToken) {
        this.setToken(openToken, closeToken, new DefaultPreparedStatementTokenHandler(), false);
    }

    public void setToken(String openToken, String closeToken, boolean addMapperKey) {
        this.setToken(openToken, closeToken, new DefaultPreparedStatementTokenHandler(), addMapperKey);
    }

    public void setToken(String openToken, String closeToken, TokenHandler token) {
        this.setToken(openToken, closeToken, new DefaultPreparedStatementTokenHandler(), false);
    }

    public void setToken(String openToken, String closeToken, TokenHandler token, boolean addMapperKey) {
        this.openToken = openToken;
        this.closeToken = closeToken;
        this.tokenHandler = token;
        if (!addMapperKey || this.mapperKeys == null) {
            this.mapperKeys = new ArrayList<String>();
        }
    }

    public void clear() {
        if (this.mapperKeys == null) {
            this.mapperKeys = new ArrayList<String>();
        }
        this.mapperKeys.clear();
    }

    public List<String> getMappingKeys() {
        return this.mapperKeys;
    }

    public String parse(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        int start = text.indexOf(this.openToken, 0);
        if (start == -1) {
            return text;
        }
        char[] src = text.toCharArray();
        int offset = 0;
        StringBuilder builder = new StringBuilder();
        StringBuilder expression = null;
        while (start > -1) {
            if (start > 0 && src[start - 1] == '\\') {
                builder.append(src, offset, start - offset - 1).append(this.openToken);
                offset = start + this.openToken.length();
            } else {
                if (expression == null) {
                    expression = new StringBuilder();
                } else {
                    expression.setLength(0);
                }
                builder.append(src, offset, start - offset);
                offset = start + this.openToken.length();
                int end = text.indexOf(this.closeToken, offset);
                while (end > -1) {
                    if (end > offset && src[end - 1] == '\\') {
                        expression.append(src, offset, end - offset - 1).append(this.closeToken);
                        offset = end + this.closeToken.length();
                        end = text.indexOf(this.closeToken, offset);
                        continue;
                    }
                    expression.append(src, offset, end - offset);
                    offset = end + this.closeToken.length();
                    break;
                }
                if (end == -1) {
                    builder.append(src, start, src.length - start);
                    offset = src.length;
                } else {
                    builder.append(this.tokenHandler.handleToken(expression.toString()));
                    offset = end + this.closeToken.length();
                }
            }
            start = text.indexOf(this.openToken, offset);
        }
        if (offset < src.length) {
            builder.append(src, offset, src.length - offset);
        }
        return builder.toString();
    }

    public List<Object[]> mapping(List<Map<String, Object>> mapperList, boolean emptyAllow, Map<Integer, Integer> o) {
        ArrayList<Object[]> objList = new ArrayList<Object[]>();
        int objSize = this.mapperKeys.size();
        block0: for (Map<String, Object> mapObj : mapperList) {
            Object[] obj = new Object[objSize];
            for (int i = 0; i < objSize; ++i) {
                obj[i] = mapObj.get(this.mapperKeys.get(i));
                if (obj[i] != null) continue;
                if (emptyAllow) {
                    obj[i] = null;
                    continue;
                }
                log.error("mapper[{}] key[{}] value is null. continue..", mapObj, (Object)this.mapperKeys.get(i));
                continue block0;
            }
            if (log.isDebugEnabled()) {
                log.debug("mapping object=[{}]", (Object)Arrays.toString(obj));
            }
            o.put(obj.hashCode(), mapObj.hashCode());
            objList.add(obj);
        }
        return objList;
    }

    public Pair<List<Object[]>, int[]> mapping1(List<Map<String, Object>> mapperList, boolean emptyAllow, Map<Integer, Integer> o) {
        List<Object[]> objList = this.mapping(mapperList, emptyAllow, o);
        int[] argTypes = null;
        if (!ObjectUtils.isEmpty(objList)) {
            Object[] objs = objList.get(0);
            argTypes = new int[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                argTypes[i] = objs[i] == null ? 0 : (objs[i] instanceof Integer ? 4 : (objs[i] instanceof Long ? 2 : (objs[i] instanceof Byte ? 2004 : 12)));
            }
        }
        return new Pair<List<Object[]>, Object>(objList, argTypes);
    }

    public Pair<List<Object[]>, MapSqlParameterSource[]> makeMapSqlParmeter(List<Map<String, Object>> mapperList, List<String> clobColumnNames, boolean emptyAllow, Map<Integer, Integer> o) {
        ArrayList<Object[]> objList = new ArrayList<Object[]>();
        MapSqlParameterSource[] ins = new MapSqlParameterSource[mapperList.size()];
        int objSize = this.mapperKeys.size();
        int index = 0;
        block0: for (Map<String, Object> mapObj : mapperList) {
            Object[] obj = new Object[objSize];
            MapSqlParameterSource in = new MapSqlParameterSource();
            for (int i = 0; i < objSize; ++i) {
                obj[i] = mapObj.get(this.mapperKeys.get(i));
                if (!ObjectUtils.isEmpty(clobColumnNames) && clobColumnNames.contains(this.mapperKeys.get(i))) {
                    if (obj[i] == null && emptyAllow) {
                        in.addValue(this.mapperKeys.get(i), (Object)new SqlLobValue("", (LobHandler)new DefaultLobHandler()), 2005);
                    } else {
                        in.addValue(this.mapperKeys.get(i), (Object)new SqlLobValue(obj[i].toString(), (LobHandler)new DefaultLobHandler()), 2005);
                    }
                } else {
                    in.addValue(this.mapperKeys.get(i), obj[i]);
                }
                if (obj[i] != null) continue;
                if (emptyAllow) {
                    obj[i] = null;
                    continue;
                }
                log.error("mapper[{}] key[{}] value is null. continue..", mapObj, (Object)this.mapperKeys.get(i));
                in = null;
                continue block0;
            }
            if (log.isDebugEnabled()) {
                log.debug("mapping object=[{}]", (Object)Arrays.toString(obj));
            }
            ins[index] = in;
            o.put(in.hashCode(), mapObj.hashCode());
            objList.add(obj);
            ++index;
        }
        return new Pair<List<Object[]>, MapSqlParameterSource[]>(objList, ins);
    }

    class DefaultPreparedStatementTokenHandler
    implements TokenHandler {
        DefaultPreparedStatementTokenHandler() {
        }

        public String handleToken(String content) {
            MapperedDataTokenHandler.this.mapperKeys.add(content);
            return "?";
        }
    }
}

