/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.jdbc.mybatis;

import java.lang.reflect.Field;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="updateLogInterceptor", args={Statement.class}), @Signature(type=StatementHandler.class, method="queryLogInterceptor", args={Statement.class, ResultHandler.class})})
public class LogInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(LogInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler handler = (StatementHandler)invocation.getTarget();
        BoundSql boundSql = handler.getBoundSql();
        String sql = boundSql.getSql();
        Object param = handler.getParameterHandler().getParameterObject();
        if (param == null) {
            sql = sql.replaceFirst("\\?", "''");
        } else if (param instanceof Integer || param instanceof Long || param instanceof Float || param instanceof Double) {
            sql = sql.replaceFirst("\\?", param.toString());
        } else if (param instanceof String) {
            sql = sql.replaceFirst("\\?", "'" + param + "'");
        } else if (param instanceof Map) {
            List paramMapping = boundSql.getParameterMappings();
            for (ParameterMapping mapping : paramMapping) {
                String propValue = mapping.getProperty();
                Object value = ((Map)param).get(propValue);
                if (value instanceof String) {
                    sql = sql.replaceFirst("\\?", "'" + value + "'");
                    continue;
                }
                sql = sql.replaceFirst("\\?", value.toString());
            }
        } else {
            List paramMapping = boundSql.getParameterMappings();
            Class<?> paramClass = param.getClass();
            for (ParameterMapping mapping : paramMapping) {
                String propValue = mapping.getProperty();
                Field field = paramClass.getDeclaredField(propValue);
                field.setAccessible(true);
                Class javaType = mapping.getJavaType();
                if (String.class == javaType) {
                    sql = sql.replaceFirst("\\?", "'" + field.get(param) + "'");
                    continue;
                }
                sql = sql.replaceFirst("\\?", field.get(param).toString());
            }
        }
        log.info("=====================================================================");
        log.info("sql : {}", (Object)sql);
        log.info("=====================================================================");
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

