/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.jdbc.mybatis;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.parsing.GenericTokenParser;
import org.apache.ibatis.parsing.TokenHandler;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicMapSqlMapper {
    private static final Logger log = LoggerFactory.getLogger(DynamicMapSqlMapper.class);
    SqlSessionFactory sqlSessionFacotry;

    public DynamicMapSqlMapper(SqlSessionFactory sqlSessionFacotry) {
        this.sqlSessionFacotry = sqlSessionFacotry;
    }

    public String dynamicBoundSql(String first, String end, String query, Map<String, String> mapper) {
        GenericTokenParser parser = new GenericTokenParser(first, end, (TokenHandler)new MapInjectTokenHandler(mapper));
        return parser.parse(query);
    }

    public String dynamicBoundSql(String query, Map<String, String> mapper) {
        GenericTokenParser parser = new GenericTokenParser("@{", "}", (TokenHandler)new MapInjectTokenHandler(mapper));
        return parser.parse(query);
    }

    public String dynamicBoundSql(String query, Object beanObject) {
        GenericTokenParser parser = new GenericTokenParser("@{", "}", (TokenHandler)new MapInjectTokenHandler(beanObject));
        return parser.parse(query);
    }

    public String dynamicBoundSql(String query, Object beanObject, String openCode) {
        GenericTokenParser parser = new GenericTokenParser(openCode, "}", (TokenHandler)new MapInjectTokenHandler(beanObject));
        return parser.parse(query);
    }

    public String dynamicBoundSql(String query) {
        TokenHandler handler = new TokenHandler(){

            public String handleToken(String content) {
                return "?";
            }
        };
        GenericTokenParser parser = new GenericTokenParser("#{", "}", handler);
        return parser.parse(query);
    }

    public String boundSql(String id) {
        Configuration configuration = this.sqlSessionFacotry.getConfiguration();
        MappedStatement mappedStatedment = configuration.getMappedStatement(id);
        BoundSql boundSql = mappedStatedment.getBoundSql(new Object());
        return boundSql.getSql();
    }

    public String boundSql(String id, Object obj) {
        Configuration configuration = this.sqlSessionFacotry.getConfiguration();
        MappedStatement mappedStatedment = configuration.getMappedStatement(id);
        BoundSql boundSql = mappedStatedment.getBoundSql(obj);
        return boundSql.getSql();
    }

    public String boundSql(SqlSessionFactory sqlSessionFactory, String id) {
        Configuration configuration = sqlSessionFactory.getConfiguration();
        MappedStatement mappedStatedment = configuration.getMappedStatement(id);
        BoundSql boundSql = mappedStatedment.getBoundSql(new Object());
        return boundSql.getSql();
    }

    public String boundConvertSql(String id, Map<String, Object> obj) {
        Configuration configuration = this.sqlSessionFacotry.getConfiguration();
        MappedStatement mappedStatedment = configuration.getMappedStatement(id);
        BoundSql boundSql = mappedStatedment.getBoundSql(obj);
        String sql = boundSql.getSql();
        Object paramObj = boundSql.getParameterObject();
        if (paramObj != null) {
            List paramMapping = boundSql.getParameterMappings();
            for (ParameterMapping mapping : paramMapping) {
                String propValue = mapping.getProperty();
                sql = sql.replaceFirst("\\?", String.valueOf(obj.get(propValue)));
            }
        }
        return sql;
    }

    public String boundOriginalSql(String id) {
        Configuration configuration = this.sqlSessionFacotry.getConfiguration();
        MappedStatement mappedStatedment = configuration.getMappedStatement(id);
        BoundSql boundSql = mappedStatedment.getBoundSql(new Object());
        String sql = boundSql.getSql();
        Object paramObj = boundSql.getParameterObject();
        if (paramObj != null) {
            List paramMapping = boundSql.getParameterMappings();
            for (ParameterMapping mapping : paramMapping) {
                String propValue = mapping.getProperty();
                sql = sql.replaceFirst("\\?", "#{" + propValue + "}");
            }
        }
        return sql;
    }

    public String getSql(String id) {
        Configuration configuration = this.sqlSessionFacotry.getConfiguration();
        MappedStatement mappedStatedment = configuration.getMappedStatement(id);
        BoundSql boundSql = mappedStatedment.getBoundSql(new Object());
        return boundSql.getSql();
    }

    class MapInjectTokenHandler
    implements TokenHandler {
        Map<String, String> mapper;
        List<Object[]> mapperArrayList = new ArrayList<Object[]>();

        public List<Object[]> mapperList() {
            return this.mapperArrayList;
        }

        public MapInjectTokenHandler(Object varialbes) {
            if (varialbes == null) {
                log.error("failed mapping. this object is null error");
                return;
            }
            if (varialbes instanceof Map) {
                this.mapper = (Map)varialbes;
            } else if (!(varialbes instanceof List)) {
                try {
                    this.mapper = BeanUtils.describe((Object)varialbes);
                }
                catch (IllegalAccessException e) {
                    log.error("0007|failed bean[{}] to map ", varialbes, (Object)e);
                }
                catch (InvocationTargetException e) {
                    log.error("0008|failed bean[{}] to map ", varialbes, (Object)e);
                }
                catch (NoSuchMethodException e) {
                    log.error("0009|failed bean[{}] to map ", varialbes, (Object)e);
                }
            }
        }

        public String handleToken(String content) {
            return this.mapper.containsKey(content) ? this.mapper.get(content) : "";
        }
    }
}

