/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.jdbc.mybatis;

import com.humuson.tms.adaptor.jdbc.DBType;
import com.humuson.tms.adaptor.jdbc.mybatis.DynamicMapSqlMapper;
import com.humuson.tms.adaptor.jdbc.mybatis.TmsBatchSqlExecutor;
import com.humuson.tms.adaptor.jdbc.mybatis.TmsDataSourceProperties;
import com.humuson.tms.adaptor.jdbc.mybatis.TmsDatabaseConfig;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnProperty(name={"tms.database.enabled"}, havingValue="true", matchIfMissing=false)
@EnableConfigurationProperties(value={DataSourceProperties.class})
public class DefaultDatabaseConfig
extends TmsDatabaseConfig {
    private static final Logger log = LoggerFactory.getLogger(DefaultDatabaseConfig.class);
    @Value(value="${tms.database.initial:false}")
    private String initDatabase;
    @Value(value="${tms.database.initial.script:}")
    private String ddlScript;
    @Value(value="${tms.database.mybatis.xml}")
    private String mybatisDaoConfig;
    @Autowired(required=false)
    private TmsDataSourceProperties dataSourceProperties;

    @Override
    @Primary
    @Bean(destroyMethod="close")
    @Qualifier(value="tmsDatasource")
    @ConditionalOnClass(value={DataSource.class})
    public DataSource dataSource() {
        BasicDataSource datasource = new BasicDataSource();
        datasource.setDriverClassName(this.dataSourceProperties.getDriverClassName());
        datasource.setUrl(this.dataSourceProperties.getUrl());
        datasource.setUsername(this.dataSourceProperties.getUsername());
        datasource.setPassword(this.dataSourceProperties.getPassword());
        datasource.setTestOnBorrow(this.dataSourceProperties.isTestOnBorrow());
        datasource.setValidationQuery(this.dataSourceProperties.getValidationQuery());
        datasource.setTestWhileIdle(this.dataSourceProperties.isTestWhileIdle());
        datasource.setMaxIdle(this.dataSourceProperties.getMaxIdle());
        datasource.setMaxTotal(this.dataSourceProperties.getMaxActive());
        this.setDefaultDatabaseType(this.dataSourceProperties.getDriverClassName());
        return datasource;
    }

    @Bean
    @Primary
    public SqlSessionFactory firstSqlSessionFactory(@Qualifier(value="tmsDatasource") DataSource firstDataSource, ApplicationContext applicationContext) throws Exception {
        return this.sqlSessionFactory(firstDataSource, applicationContext, this.mybatisDaoConfig);
    }

    @Bean(name={"dynamicMapSqlMapper"})
    public DynamicMapSqlMapper dynamicMapSqlMapper(SqlSessionFactory sqlSessionFactory) {
        return new DynamicMapSqlMapper(sqlSessionFactory);
    }

    @Bean(name={"tmsBatchSqlExecutor"})
    public <T> TmsBatchSqlExecutor<T> tmsBatchSqlExecutor(SqlSessionFactory sqlSessionFactory) {
        return new TmsBatchSqlExecutor(sqlSessionFactory);
    }

    public DBType getDefaultDBType() {
        return this.getDbType();
    }
}

