/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.jdbc.mybatis;

import com.humuson.tms.adaptor.jdbc.mybatis.LargeSelectExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.PostConstruct;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.TransactionIsolationLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Component
@ConditionalOnBean(name={"sqlSessionFacotry"})
public class BatchSqlExecutor<T> {
    private static final Logger log = LoggerFactory.getLogger(BatchSqlExecutor.class);
    @Autowired
    SqlSessionFactory sqlSessionFactory;
    @Value(value="${tms.db.batch.commit.count:100}")
    private int _COMMIT_SIZE;
    @Value(value="${adaptor.batch.error.thread-count:10}")
    private int threadCount;
    private ExecutorService execService = null;
    DefaultTransactionDefinition transactionDefinition;
    @Autowired(required=false)
    PlatformTransactionManager transactionManager;
    final ThreadGroup threadGroup = new ThreadGroup("batchSqlSingleWorkers");

    @PostConstruct
    public void init() {
        this.transactionDefinition = new DefaultTransactionDefinition();
        this.transactionDefinition.setPropagationBehavior(3);
        this.transactionDefinition.setIsolationLevel(2);
    }

    public void batchUpdate(String queryId, List<T> T) throws Exception {
        this.batchUpdateResponse(queryId, T, true);
    }

    public void batchUpdate(String queryId, List<T> T, boolean ifErrorThenOneByOneCommit) throws Exception {
        this.batchUpdateResponse(queryId, T, ifErrorThenOneByOneCommit);
    }

    public TmsBatchSqlExecutorResponse batchUpdateResponse(String queryId, List<T> T, boolean ifErrorThenOneByOneCommit) throws Exception {
        TmsBatchSqlExecutorResponse tmsExecutor = new TmsBatchSqlExecutorResponse(queryId, T.size());
        SqlSession sqlSession = this.sqlSessionFactory.openSession(ExecutorType.BATCH, TransactionIsolationLevel.READ_COMMITTED);
        if (queryId.isEmpty() || T == null) {
            throw new Exception();
        }
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("batch sql query id[{}] list count[{}]", (Object)queryId, (Object)T.size());
        }
        this.batchUpdate(sqlSession, queryId, T, tmsExecutor, ifErrorThenOneByOneCommit);
        long end = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("batch sql query id[{}] list count[{}] query millisecond[{}] ", new Object[]{queryId, T.size(), end - start});
        }
        return tmsExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchUpdate(SqlSession sqlSession, String queryId, List<T> T, TmsBatchSqlExecutorResponse tmsExecutor, boolean ifErrorThenOneByOneCommit) {
        if (log.isDebugEnabled()) {
            log.info("batch update size[{}] start", (Object)T.size());
        }
        try {
            int listSize = T.size();
            ArrayList<T> singleUpdater = new ArrayList<T>();
            for (int i = 0; i < listSize; ++i) {
                singleUpdater.add(T.get(i));
                this.query(sqlSession, queryId, T.get(i));
                if (!ifErrorThenOneByOneCommit || i % this._COMMIT_SIZE != 0) continue;
                this.commit(sqlSession, queryId, singleUpdater, tmsExecutor, ifErrorThenOneByOneCommit);
            }
            this.commit(sqlSession, queryId, singleUpdater, tmsExecutor, ifErrorThenOneByOneCommit);
        }
        catch (Exception e) {
            log.error("sql[{}] batch update error", (Object)queryId, (Object)e);
            if (!ifErrorThenOneByOneCommit) {
                throw e;
            }
            if (e.toString().indexOf("ORA-01000") > 0) {
                throw e;
            }
        }
        finally {
            sqlSession.commit(true);
            sqlSession.close();
        }
    }

    public void query(SqlSession sqlSession, String queryId, T t) {
        sqlSession.update(queryId, t);
    }

    private void commit(SqlSession sqlSession, String queryId, List<T> singleTempDatas, TmsBatchSqlExecutorResponse tmsExecutor, boolean ifErrorOneByOneCommit) {
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)this.transactionDefinition);
        try {
            if (log.isDebugEnabled()) {
                List results = sqlSession.flushStatements();
                for (BatchResult result : results) {
                    log.debug("sql = {} ", (Object)result.getSql());
                    int[] updateds = result.getUpdateCounts();
                    for (int i = 0; i < updateds.length; ++i) {
                        if (updateds[i] == 1) continue;
                        log.warn("batch update/insert is not one data. upate/insert count[{}] point={}/{}", new Object[]{updateds[i], i, updateds.length});
                    }
                }
            }
            this.transactionManager.commit(status);
        }
        catch (Exception e) {
            this.transactionManager.rollback(status);
            log.error("batch query[{}] error. rollback \nsingle update thread[{}] starting ", (Object)queryId, (Object)e);
            if (!ifErrorOneByOneCommit) {
                log.error("don't one by one commit. so throw error");
                throw e;
            }
            if (e.getMessage().indexOf("ORA-01000") > 0) {
                throw e;
            }
            TransctionSingleQuery<T> singleQuery = new TransctionSingleQuery<T>(queryId, singleTempDatas, tmsExecutor);
            log.info("single one by one query commit starting");
            singleQuery.run();
        }
    }

    public void selectForLarge(String queryId, Map<String, Object> parameter, LargeSelectExecutor<T> lse) {
        this.selectForLarge(this.sqlSessionFactory.openSession(), queryId, parameter, lse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectForLarge(SqlSession selectSession, String queryId, Map<String, Object> parameter, LargeSelectExecutor<T> lse) {
        try {
            if (parameter == null) {
                selectSession.select(queryId, lse);
            } else {
                selectSession.select(queryId, parameter, lse);
            }
        }
        finally {
            try {
                if (selectSession != null) {
                    selectSession.close();
                }
            }
            catch (Exception e2) {
                log.error("don't session close large select data Exception {}", (Object)e2.toString());
            }
        }
    }

    private class TransctionSingleQuery<T>
    implements Runnable {
        final SqlSession sqlSession;
        final String queryId;
        final List<T> Tlist;
        TmsBatchSqlExecutorResponse tmsExecutor;

        TransctionSingleQuery(String queryId, List<T> TL, TmsBatchSqlExecutorResponse tmsExecutor) {
            log.info("single thread[{}] staring query[{}] data size[{}]", new Object[]{Thread.currentThread().getName(), queryId, TL.size()});
            this.sqlSession = BatchSqlExecutor.this.sqlSessionFactory.openSession(ExecutorType.SIMPLE);
            this.sqlSession.commit(true);
            this.queryId = queryId;
            this.Tlist = TL;
            this.tmsExecutor = tmsExecutor;
        }

        @Override
        public void run() {
            try {
                for (T t : this.Tlist) {
                    try {
                        this.sqlSession.update(this.queryId, t);
                    }
                    catch (Exception e) {
                        if (this.tmsExecutor.getFails().contains(t)) {
                            log.warn("this contains alread exist in fails. so continue. queryId[{}], data={}", (Object)this.queryId, t);
                            continue;
                        }
                        this.tmsExecutor.addFails(t);
                        log.error("query id[{}] single query error data[{}], error-msg={}", new Object[]{this.queryId, t, e.getMessage()});
                    }
                }
            }
            catch (Exception e2) {
                if (this.Tlist != null) {
                    for (T t : this.Tlist) {
                        if (this.tmsExecutor.getFails().contains(t)) {
                            log.warn("this contains alread exist in fails. so continue. queryId[{}], data={}", (Object)this.queryId, t);
                            continue;
                        }
                        this.tmsExecutor.addFails(t);
                        log.error("query id[{}] single query error data[{}], error-msg={}", new Object[]{this.queryId, t, e2.getMessage()});
                    }
                }
                log.error("query id[{}] single error ", (Object)this.queryId, (Object)e2);
            }
        }
    }

    public class TmsBatchSqlExecutorResponse {
        private List fails;
        private final String key;
        private final int size;

        private TmsBatchSqlExecutorResponse(String key, int size) {
            this.key = key;
            this.size = size;
        }

        public List getFails() {
            if (this.fails == null) {
                this.fails = new ArrayList();
            }
            return this.fails;
        }

        public void addFails(Object t) {
            this.fails.add(t);
        }

        public String toString() {
            return "BatchSqlExecutor.TmsBatchSqlExecutorResponse(fails=" + this.getFails() + ", key=" + this.key + ", size=" + this.size + ")";
        }
    }
}

