/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.jdbc;

import com.humuson.tms.adaptor.jdbc.DBType;
import com.humuson.tms.adaptor.jdbc.mybatis.TmsDataSourceProperties;
import com.humuson.tms.config.ClassDispatcher;
import com.humuson.tms.config.TmsCommonConfig;
import com.humuson.tms.crypto.HumusonDecryptor;
import com.humuson.tms.util.date.DateUtil;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

public enum TmsBatchDataSourceManager {
    INSTANCE;

    private static final Logger log;
    private Map<String, DataSource> dataSourceContainer;
    private Map<String, Integer> lastUsedTime;
    private final TmsDataSourceProperties tmsDataSourceProperties;
    final boolean isConnectionMaintain;
    final int minIdle;
    final int maxActive;
    Set<DataSource> dataSourceManager = new HashSet<DataSource>();
    private final String ENCRYPT_KEY;

    private TmsBatchDataSourceManager() {
        TmsCommonConfig config = (TmsCommonConfig)ClassDispatcher.getApplicationContext().getBean(TmsCommonConfig.class);
        this.ENCRYPT_KEY = config.getHumusonKey();
        this.tmsDataSourceProperties = (TmsDataSourceProperties)((Object)ClassDispatcher.getApplicationContext().getBean(TmsDataSourceProperties.class));
        this.isConnectionMaintain = this.tmsDataSourceProperties.isExConnectionMaintain();
        this.minIdle = this.tmsDataSourceProperties.getExMinIdle();
        this.maxActive = this.tmsDataSourceProperties.getExMaxActive();
        this.dataSourceContainer = new HashMap<String, DataSource>();
        this.lastUsedTime = new ConcurrentHashMap<String, Integer>();
    }

    public Map<String, Integer> usedTime() {
        return this.lastUsedTime;
    }

    public DataSource getDefaultDataSource() {
        return this.getDefaultDataSource(this.isConnectionMaintain);
    }

    public DataSource getDefaultDataSource(boolean isMaintain) {
        return this.getDataSource(this.tmsDataSourceProperties.getUrl(), this.tmsDataSourceProperties.getDriverClassName(), this.tmsDataSourceProperties.getUsername(), this.decryptPwd(this.tmsDataSourceProperties.getPassword()), isMaintain);
    }

    public DataSource getDataSource(Map<String, Object> resource) {
        return this.getDataSource(resource, this.isConnectionMaintain);
    }

    public DataSource getDataSource(Map<String, Object> resource, boolean isMaintain) {
        return this.getDataSource(resource.get("DB_URL").toString(), resource.get("DB_DRV").toString(), resource.get("DB_USR").toString(), resource.get("DB_PWD").toString(), isMaintain);
    }

    public DataSource getDataSource(String url, String drv, String user, String pwd) {
        return this.getDataSource(url, drv, user, pwd, this.isConnectionMaintain);
    }

    public DataSource getDataSource(String url, String drv, String user, String pwd, boolean isMaintain) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DB_URL", url);
        map.put("DB_DRV", drv);
        map.put("DB_USR", user);
        map.put("DB_PWD", pwd);
        return this.createDataSource(1000, map, isMaintain);
    }

    public DataSource getDataSource(int dbId, String url, String drv, String user, String pwd, boolean isMaintain) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DB_URL", url);
        map.put("DB_DRV", drv);
        map.put("DB_USR", user);
        map.put("DB_PWD", pwd);
        return this.createDataSource(dbId, map, isMaintain);
    }

    public DataSource getDataSource(int dbId) {
        return this.getDataSource(dbId, this.isConnectionMaintain);
    }

    public DataSource getDataSource(int dbId, boolean isMaintain) {
        try {
            Map<String, Object> map = this.getTmsTargetDatabaseInfo(dbId);
            return this.createDataSource(dbId, map, isMaintain);
        }
        catch (ClassNotFoundException e) {
            log.error("error call datasource[db_id={}] return null", (Object)dbId, (Object)e);
            return null;
        }
    }

    public synchronized Connection getDBConnection(int dbId) {
        Connection dbConnection = null;
        Map<String, Object> map = null;
        try {
            map = this.getTmsTargetDatabaseInfo(dbId);
            Class.forName(map.get("DB_DRV").toString());
            dbConnection = DriverManager.getConnection(map.get("DB_URL").toString(), map.get("DB_USR").toString(), this.decryptPwd(map));
            return dbConnection;
        }
        catch (ClassNotFoundException e) {
            log.error("db_id[{}] driver[{}] don't find class", new Object[]{dbId, map, e});
        }
        catch (SQLException e1) {
            log.error("db_id[{}] driver[{}] create connection error", new Object[]{dbId, map, e1});
        }
        return dbConnection;
    }

    public synchronized Connection getDBConnection(Map<String, Object> map) {
        Connection dbConnection = null;
        try {
            Class.forName(map.get("DB_DRV").toString());
            dbConnection = DriverManager.getConnection(map.get("DB_URL").toString(), map.get("DB_USR").toString(), this.decryptPwd(map));
            return dbConnection;
        }
        catch (ClassNotFoundException e) {
            log.error("db driver[{}] don't find class", map, (Object)e);
        }
        catch (SQLException e1) {
            log.error("db driver[{}] create connection error", map, (Object)e1);
        }
        return dbConnection;
    }

    public synchronized Connection getDBConnection(String url, String driver, String user, String pass) {
        Connection dbConnection = null;
        try {
            Class.forName(driver);
            dbConnection = DriverManager.getConnection(url, user, this.decryptPwd(pass));
            return dbConnection;
        }
        catch (ClassNotFoundException e) {
            log.error("db driver[driver={}, url={}, user={}, pass={}] don't find class", new Object[]{driver, url, user, pass, e});
        }
        catch (SQLException e1) {
            log.error("db driver[driver={}, url={}, user={}, pass={}] create connection error", new Object[]{driver, url, user, pass, e1});
        }
        return dbConnection;
    }

    /*
     * Exception decompiling
     */
    public Map<String, Object> getTmsTargetDatabaseInfo(int dbId) throws ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized void destory(DataSource datasource) {
        if (this.dataSourceContainer.containsValue(datasource)) {
            log.warn("this datasource[{}] don't destroy because of it is being managed in a datasource container", (Object)datasource);
            return;
        }
        if (datasource instanceof HikariDataSource) {
            ((HikariDataSource)datasource).close();
        } else if (datasource instanceof DriverManagerDataSource) {
            try {
                ((DriverManagerDataSource)datasource).getConnection().close();
            }
            catch (Exception e) {
                log.error("don't closing driver manager datasource[{}]", (Object)datasource, (Object)e);
            }
        } else if (datasource instanceof BasicDataSource) {
            try {
                ((BasicDataSource)datasource).close();
            }
            catch (SQLException e) {
                log.error("don't closing basic datasource[{}]", (Object)datasource, (Object)e);
            }
        }
    }

    private void dataSourceDetect(DataSource datasource) {
        for (String key : this.dataSourceContainer.keySet()) {
            if (datasource.hashCode() != this.dataSourceContainer.get(key).hashCode()) continue;
            if (datasource instanceof HikariDataSource) {
                ((HikariDataSource)datasource).close();
                this.dataSourceContainer.remove(key);
                log.info("datasource[{}] closed", (Object)((HikariDataSource)datasource).getPoolName());
                continue;
            }
            try {
                datasource.getConnection().close();
            }
            catch (SQLException e) {
                log.error("error closeing datasource[{}] ", (Object)datasource, (Object)e);
            }
        }
    }

    private synchronized DataSource createDataSource(int dbId, Map<String, Object> map, boolean isMaintain) {
        String key = map.get("DB_URL").toString() + map.get("DB_USR").toString() + this.decryptPwd(map);
        if (this.dataSourceContainer.containsKey(key)) {
            this.lastUsedTime.put(key, Integer.valueOf(DateUtil.getWorkday()));
            if (this.isConnectionClosed(key)) {
                this.removeDataSource(key);
            } else {
                return this.dataSourceContainer.get(key);
            }
        }
        if (this.isDB2(map.get("DB_DRV").toString())) {
            BasicDataSource dmDatasource = new BasicDataSource();
            dmDatasource.setDriverClassName(map.get("DB_DRV").toString());
            dmDatasource.setUrl(map.get("DB_URL").toString());
            dmDatasource.setUsername(map.get("DB_USR").toString());
            dmDatasource.setPassword(this.decryptPwd(map));
            this.dataSourceContainer.put(map.get("DB_URL").toString(), (DataSource)dmDatasource);
            return dmDatasource;
        }
        HikariConfig config = new HikariConfig();
        config.setDriverClassName(map.get("DB_DRV").toString());
        config.setJdbcUrl(map.get("DB_URL").toString());
        config.setUsername(map.get("DB_USR").toString());
        config.setPassword(this.decryptPwd(map));
        config.setConnectionInitSql("select 1 from dual");
        config.setValidationTimeout(60000L);
        config.addDataSourceProperty("cachePrepStmts", (Object)"true");
        config.addDataSourceProperty("implicitCachingEnabled", (Object)"true");
        config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
        config.addDataSourceProperty("characterEncoding", (Object)"utf8");
        config.addDataSourceProperty("useUnicode", (Object)"true");
        HikariDataSource dataSource = new HikariDataSource(config);
        dataSource.setPoolName(this.makePoolName(map.get("DB_DRV").toString(), map.get("DB_URL").toString()));
        dataSource.setIdleTimeout(0L);
        dataSource.setTransactionIsolation("TRANSACTION_READ_COMMITTED");
        dataSource.setMaxLifetime(3600000L);
        if (map.containsKey("MAX_POOL_SIZE")) {
            dataSource.setMaximumPoolSize(((Integer)map.get("MAX_POOL_SIZE")).intValue());
        } else {
            dataSource.setMaximumPoolSize(this.maxActive);
        }
        if (map.containsKey("MIN_IDLE_SIZE")) {
            dataSource.setMinimumIdle(((Integer)map.get("MIN_IDLE_SIZE")).intValue());
        } else {
            dataSource.setMinimumIdle(this.minIdle);
        }
        dataSource.setConnectionTimeout(0L);
        if (isMaintain) {
            this.dataSourceContainer.put(key, (DataSource)dataSource);
        }
        return dataSource;
    }

    private boolean isConnectionClosed(String key) {
        try {
            HikariDataSource datasource = (HikariDataSource)this.dataSourceContainer.get(key);
            return datasource.isClosed();
        }
        catch (Exception e) {
            log.warn("this key[{}] get connection error. so create datasource ", (Object)key, (Object)e);
            return true;
        }
    }

    private String decryptPwd(String pwd) {
        try {
            pwd = HumusonDecryptor.decrypt(pwd, this.ENCRYPT_KEY);
        }
        catch (Exception e) {
            log.warn("pwd decrypt error. so return org data [{}]", (Object)pwd);
        }
        return pwd;
    }

    private String decryptPwd(Map<String, Object> map) {
        String pwd = map.get("DB_PWD").toString();
        try {
            pwd = HumusonDecryptor.decrypt(pwd, this.ENCRYPT_KEY);
        }
        catch (Exception e) {
            log.warn("pwd decrypt error. so return org data [{}]", (Object)pwd);
        }
        return pwd;
    }

    private boolean isDB2(String driver) {
        return driver.toUpperCase().indexOf("IBM") > 0;
    }

    private String getDatabaseType(String driverClassName) {
        try {
            for (DBType type : DBType.values()) {
                if (driverClassName.toLowerCase().indexOf(type.name().toLowerCase()) < 0) continue;
                return type.name();
            }
        }
        catch (Exception e) {
            log.error("db type detect error return null. driver_class_name[{}]", (Object)driverClassName, (Object)e);
            return null;
        }
        return null;
    }

    private String makePoolName(String drvClassName, String url) {
        String dbType = this.getDatabaseType(drvClassName);
        if (dbType == null) {
            return "DB-TYPE:EMPTY";
        }
        return "DIRECT-" + dbType + ":" + this.getURL(dbType, url);
    }

    private String getURL(String dbType, String url) {
        try {
            if (DBType.ORACLE.name().equals(dbType)) {
                return url.substring(url.indexOf("@") + 1);
            }
            if (DBType.MARIA.name().equals(dbType) || DBType.MYSQL.name().equals(dbType)) {
                return url.substring(url.indexOf("://") + 1, url.lastIndexOf("/"));
            }
        }
        catch (Exception e) {
            log.warn("db-type[{}], url[{}] poolname setting error. so set poolname=IP-EMPTY", new Object[]{dbType, url, e});
        }
        return "IP-EMPTY";
    }

    private String decryptPassward(int dbId, Map<String, Object> map) throws Exception {
        try {
            return HumusonDecryptor.decrypt(map.get("DB_PWD").toString(), this.ENCRYPT_KEY);
        }
        catch (Exception e) {
            log.warn("db[{}] connection decrypt error. so return orginal pw={}", (Object)dbId, map.get("DB_PWD"));
            return map.get("DB_PWD").toString();
        }
    }

    public synchronized void removeDataSource(String key) {
        try {
            HikariDataSource datasource = (HikariDataSource)this.dataSourceContainer.get(key);
            if (!datasource.isClosed()) {
                datasource.close();
            }
            datasource = null;
        }
        catch (ClassCastException ce) {
            DataSource datasource = this.dataSourceContainer.get(key);
            try {
                if (!datasource.getConnection().isClosed()) {
                    datasource.getConnection().close();
                    log.info("datasource[{}] close and datasource container remove", (Object)datasource.toString());
                }
                datasource = null;
            }
            catch (SQLException e) {
                log.error("datasource connection close error", (Object)datasource);
            }
        }
        catch (Exception e) {
            log.error("datasource close error.", (Throwable)e);
        }
        this.dataSourceContainer.remove(key);
        this.lastUsedTime.remove(key);
    }

    static {
        log = LoggerFactory.getLogger(TmsBatchDataSourceManager.class);
    }
}

