/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.jdbc;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public class PlatformUtils {
    static final String MYSQL = "MySQL";
    static final String ORACLE = "Oracle";
    private Map<String, String> jdbcSubProtocolToPlatform = new HashMap<String, String>();

    PlatformUtils() {
        this.jdbcSubProtocolToPlatform.put("mysql", MYSQL);
        this.jdbcSubProtocolToPlatform.put("oracle:thin", ORACLE);
        this.jdbcSubProtocolToPlatform.put("oracle:oci8", ORACLE);
        this.jdbcSubProtocolToPlatform.put("oracle:dnldthin", ORACLE);
    }

    String determineDatabaseType(DataSource dataSource) {
        String jdbcConnectionUrl = this.getURL(dataSource);
        if (jdbcConnectionUrl == null) {
            return null;
        }
        for (Map.Entry<String, String> entry : this.jdbcSubProtocolToPlatform.entrySet()) {
            String subProtocol = "jdbc:" + entry.getKey() + ":";
            if (!jdbcConnectionUrl.startsWith(subProtocol)) continue;
            return entry.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getURL(DataSource dataSource) {
        try {
            Method m = dataSource.getClass().getMethod("getUrl", new Class[0]);
            return (String)m.invoke((Object)dataSource, new Object[0]);
        }
        catch (Exception e) {
            Connection connection = null;
            try {
                connection = dataSource.getConnection();
                DatabaseMetaData metaData = connection.getMetaData();
                String string = metaData.getURL();
                return string;
            }
            catch (SQLException se) {
                String string = null;
                return string;
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }
}

