/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.jdbc;

import com.humuson.tms.adaptor.jdbc.BizSqlException;
import com.humuson.tms.adaptor.jdbc.TmsRowMapperExecutor;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LinkedHashMapRowMapperExecutor
extends TmsRowMapperExecutor<LinkedHashMap<String, Object>> {
    private static final Logger log = LoggerFactory.getLogger(LinkedHashMapRowMapperExecutor.class);
    boolean isColumnModify;

    public LinkedHashMapRowMapperExecutor(boolean isColumnModify) {
        super(isColumnModify);
        this.isColumnModify = isColumnModify;
    }

    @Override
    public LinkedHashMap<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
        return this.commonRowMapping(rs);
    }

    @Override
    protected LinkedHashMap<String, Object> commonRowMapping(ResultSet rs) throws SQLException {
        LinkedHashMap<String, Object> mapping = new LinkedHashMap<String, Object>();
        ResultSetMetaData rsmd = rs.getMetaData();
        int cnt = rsmd.getColumnCount();
        for (int loop = 0; loop < cnt; ++loop) {
            if (this.isLargeType(rsmd.getColumnType(loop + 1))) {
                this.largeDataMapping(mapping, rs, rsmd.getColumnType(loop + 1), rsmd.getColumnName(loop + 1), rsmd.getColumnLabel(loop + 1));
                continue;
            }
            if (this.isColumnModify) {
                this.columnMapping(mapping, rsmd.getColumnLabel(loop + 1), rs.getObject(loop + 1));
                continue;
            }
            mapping.put(rsmd.getColumnLabel(loop + 1), rs.getObject(loop + 1));
        }
        this.execute(mapping);
        return mapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void largeDataMapping(LinkedHashMap<String, Object> mapping, ResultSet rs, int columnType, String columnName, String columnLabel) throws SQLException {
        if (columnType == 2005) {
            if (log.isDebugEnabled()) {
                log.debug("clob select column name[{}]", (Object)columnName);
            }
            Clob clob = null;
            try {
                clob = rs.getClob(columnName);
                String clobStr = "";
                if (clob != null) {
                    clobStr = clob.getSubString(1L, (int)clob.length());
                }
                if (log.isDebugEnabled()) {
                    log.debug("clob selected column name[{}] lavel[{}] value[{}]", new Object[]{columnName, columnLabel, clobStr});
                }
                mapping.put(columnLabel, clobStr);
            }
            finally {
                if (clob != null) {
                    clob.free();
                }
            }
        } else if (columnType == 2004) {
            Blob blobContent = rs.getBlob(columnName);
            byte[] bytes = blobContent.getBytes(1L, (int)blobContent.length());
            mapping.put(columnLabel, bytes);
            blobContent.free();
        }
    }

    private boolean isLargeType(int columnType) {
        return columnType == 2005 || columnType == 2004;
    }

    protected abstract void execute(LinkedHashMap<String, Object> var1) throws BizSqlException;

    protected abstract void columnMapping(LinkedHashMap<String, Object> var1, String var2, Object var3);
}

