/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.jdbc;

import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
@Scope(value="prototype")
public class DynamicJdbcTemplate {
    private static final Logger log = LoggerFactory.getLogger(DynamicJdbcTemplate.class);
    @Autowired
    DataSource datasource;
    String databaseType;

    public String databaseType() {
        return this.databaseType;
    }

    public JdbcTemplate createDatasource(String url, String driver, String user, String pass) {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(driver);
        dataSource.setUrl(url);
        dataSource.setUsername(user);
        dataSource.setPassword(pass);
        dataSource.setMinIdle(1);
        dataSource.setMaxIdle(1);
        dataSource.setMaxOpenPreparedStatements(300);
        return this.createDatasource((DataSource)dataSource);
    }

    public DataSource dataSource(String url, String driver, String user, String pass) {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(driver);
        dataSource.setUrl(url);
        dataSource.setUsername(user);
        dataSource.setPassword(pass);
        return dataSource;
    }

    public JdbcTemplate createDatasource(DataSource datasource) {
        return new JdbcTemplate(datasource);
    }

    public JdbcTemplate datasource() {
        return this.createDatasource(this.datasource);
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate(this.datasource);
    }

    public JdbcTemplate jdbcTemplate(DataSource datasource) {
        return this.createDatasource(datasource);
    }
}

