/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.jdbc;

import com.humuson.tms.adaptor.jdbc.DBType;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DBTypeDetector {
    public static DBType databaseType(String driverClassName) {
        for (DBType type : DBType.values()) {
            for (String signature : type.DB_SIGNATURE) {
                if (driverClassName.toLowerCase().indexOf(signature.toLowerCase()) < 0) continue;
                return type;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getURL(DataSource dataSource) {
        try {
            Method m = dataSource.getClass().getMethod("getUrl", new Class[0]);
            return (String)m.invoke((Object)dataSource, new Object[0]);
        }
        catch (Exception e) {
            Connection connection = null;
            try {
                connection = dataSource.getConnection();
                DatabaseMetaData metaData = connection.getMetaData();
                String string = metaData.getURL();
                return string;
            }
            catch (SQLException se) {
                String string = null;
                return string;
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }
}

