/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.ftp;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.messaging.MessageChannel;

public class DynamicFtpChannelResolver {
    public static final int MAX_CACHE_SIZE = 2;
    private final LinkedHashMap<String, MessageChannel> channels = new LinkedHashMap<String, MessageChannel>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, MessageChannel> eldest) {
            boolean remove;
            boolean bl = remove = this.size() > 2;
            if (remove) {
                MessageChannel channel = eldest.getValue();
                ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)DynamicFtpChannelResolver.this.contexts.get(channel);
                if (ctx != null) {
                    ctx.close();
                    DynamicFtpChannelResolver.this.contexts.remove(channel);
                }
            }
            return remove;
        }
    };
    private final Map<MessageChannel, ConfigurableApplicationContext> contexts = new HashMap<MessageChannel, ConfigurableApplicationContext>();

    public MessageChannel resolve(String customer) {
        MessageChannel channel = this.channels.get(customer);
        if (channel == null) {
            channel = this.createNewCustomerChannel(customer);
        }
        return channel;
    }

    private synchronized MessageChannel createNewCustomerChannel(String customer) {
        MessageChannel channel = this.channels.get(customer);
        if (channel == null) {
            ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(new String[]{"/META-INF/spring/integration/dynamic-ftp-outbound-adapter-context.xml"}, false);
            this.setEnvironmentForCustomer((ConfigurableApplicationContext)ctx, customer);
            ctx.refresh();
            channel = (MessageChannel)ctx.getBean("toFtpChannel", MessageChannel.class);
            this.channels.put(customer, channel);
            this.contexts.put(channel, (ConfigurableApplicationContext)ctx);
        }
        return channel;
    }

    private void setEnvironmentForCustomer(ConfigurableApplicationContext ctx, String customer) {
        StandardEnvironment env = new StandardEnvironment();
        Properties props = new Properties();
        props.setProperty("host", "host.for." + customer);
        props.setProperty("user", "user");
        props.setProperty("password", "password");
        props.setProperty("remote.directory", "/tmp");
        PropertiesPropertySource pps = new PropertiesPropertySource("ftpprops", props);
        env.getPropertySources().addLast((PropertySource)pps);
        ctx.setEnvironment((ConfigurableEnvironment)env);
    }
}

