/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.activemq;

import com.humuson.tms.adaptor.activemq.ActivemqConnectorConfig;
import javax.jms.Queue;
import org.apache.activemq.command.ActiveMQQueue;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.annotation.EnableJms;

@EnableJms
@Configuration
@ConditionalOnClass(value={ActivemqConnectorConfig.class})
public class ActivemqQueueConfig {
    public static final String CONTROLLER_QUEUE = "controller.queue";
    public static final String MAPPER_QUEUE = "mapper.queue";
    public static final String SENDER_QUEUE = "sender.queue";
    public static final String SENDER_MAIL_QUEUE = "sender.queue.mail";
    public static final String SENDER_APNS_QUEUE = "sender.queue.push.apns";
    public static final String SENDER_HTTP_QUEUE = "sender.queue.push.http";
    public static final String SENDER_XMPP_QUEUE = "sender.queue.push.xmpp";
    public static final String SENDER_SMS_QUEUE = "sender.queue.sms";
    public static final String MANAGER_QUEUE = "manager.queue";
    public static final String ORDER_QUEUE = "order-queue";
    public static final String HELLO_WORLD_QUEUE = "hello.world.queue";
    public static final String TEST_FAILOVER_QUEUE = "test.failover.queue";

    @Bean(value={"controller.queue"})
    public Queue controllerQueue() {
        return new ActiveMQQueue(CONTROLLER_QUEUE);
    }

    @Bean(value={"mapper.queue"})
    public Queue mapperQueue() {
        return new ActiveMQQueue(MAPPER_QUEUE);
    }

    @Bean(value={"sender.queue"})
    public Queue senderQueue() {
        return new ActiveMQQueue(SENDER_QUEUE);
    }

    @Bean(value={"sender.queue.push.apns"})
    public Queue senderAPNSQueue() {
        return new ActiveMQQueue(SENDER_APNS_QUEUE);
    }

    @Bean(value={"sender.queue.push.http"})
    public Queue senderHTTPQueue() {
        return new ActiveMQQueue(SENDER_HTTP_QUEUE);
    }

    @Bean(value={"sender.queue.push.xmpp"})
    public Queue senderXMPPQueue() {
        return new ActiveMQQueue(SENDER_XMPP_QUEUE);
    }

    @Bean(value={"sender.queue.sms"})
    public Queue senderSMSQueue() {
        return new ActiveMQQueue(SENDER_SMS_QUEUE);
    }

    @Bean(value={"manager.queue"})
    public Queue managerQueue() {
        return new ActiveMQQueue(MANAGER_QUEUE);
    }

    @Bean(value={"hello.world.queue"})
    public Queue helloWorldJMSQueue() {
        return new ActiveMQQueue(HELLO_WORLD_QUEUE);
    }

    @Bean(value={"test.failover.queue"})
    public Queue failOverTestQueue() {
        return new ActiveMQQueue(TEST_FAILOVER_QUEUE);
    }
}

