/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.activemq;

import com.humuson.tms.adaptor.activemq.ActiveMQSender;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.annotation.EnableJms;
import org.springframework.jms.core.JmsTemplate;

@Configuration
@EnableJms
@ConditionalOnProperty(prefix="spring.activemq", name={"broker-url"})
public class ActivemqConnectorConfig {
    @Value(value="${spring.activemq.broker-url:}")
    private String brokerUrl;
    @Value(value="${spring.activemq.pool.default-queue-name:}")
    private String queueName;
    @Value(value="${spring.activemq.pool.max-connections:30}")
    public int maxConnections;

    @Bean(value={"ActiveMQConnectionFactory"})
    protected ConnectionFactory activeMQConnectionFactory() {
        ActiveMQConnectionFactory activeMQConnectionFactory = new ActiveMQConnectionFactory();
        activeMQConnectionFactory.setBrokerURL(this.brokerUrl);
        activeMQConnectionFactory.setUseAsyncSend(true);
        activeMQConnectionFactory.setAlwaysSessionAsync(true);
        activeMQConnectionFactory.setMessagePrioritySupported(true);
        activeMQConnectionFactory.setMaxThreadPoolSize(this.maxConnections);
        return activeMQConnectionFactory;
    }

    @Bean
    public JmsTemplate jmsTemplate() {
        return new JmsTemplate(this.activeMQConnectionFactory());
    }

    @Bean(name={"activemq-sender"})
    public ActiveMQSender sender() {
        ActiveMQSender sender = new ActiveMQSender();
        sender.setactiveMQSenderConfig(this);
        return sender;
    }
}

