/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.adaptor.activemq;

import com.humuson.tms.adaptor.activemq.ActivemqConnectorConfig;
import com.humuson.tms.util.seq.TimeUtil;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.jca.cci.connection.SingleConnectionFactory;
import org.springframework.jms.core.JmsTemplate;

@ConditionalOnClass(value={ActivemqConnectorConfig.class})
public class ActiveMQSender {
    private static final Logger log = LoggerFactory.getLogger(ActiveMQSender.class);
    @Autowired
    private JmsTemplate jmsTemplate;
    @Value(value="${spring.jms.template.default-destination}")
    private String defaultDestination;
    @Value(value="${spring.jms.retry.cycle:10}")
    private int retryMillisecondCycle;
    private ActivemqConnectorConfig activeMQSenderConfig;

    public void setactiveMQSenderConfig(ActivemqConnectorConfig activeMQReceiverConfig) {
        this.activeMQSenderConfig = activeMQReceiverConfig;
    }

    public ActivemqConnectorConfig getactiveMQSenderConfig() {
        return this.activeMQSenderConfig;
    }

    @PostConstruct
    public void init() {
        this.jmsTemplate.setSessionTransacted(true);
    }

    public void send(String destination, String message) {
        if (log.isDebugEnabled()) {
            log.debug("activemq sending message='{}' to destination='{}'", (Object)message, (Object)destination);
        }
        try {
            this.jmsTemplate.convertAndSend(destination, (Object)message);
        }
        catch (Exception e) {
            log.error("fail activemq message sending destination[{}], message[{}] \nso retry() ", new Object[]{destination, message, e});
            this.retry();
            this.send(destination, message, 100);
        }
    }

    public void send(String destination, String message, int delay) {
        try {
            TimeUtil.mileSecondsLockSleep(delay);
            this.jmsTemplate.convertAndSend(destination, (Object)message);
        }
        catch (Exception e) {
            log.error("fail activemq message sending destination[{}], message[{}] \nso retry() cycle({})", new Object[]{destination, message, delay, e});
            this.retry();
            this.send(destination, message, delay *= 2);
        }
    }

    public void retry() {
        if (this.jmsTemplate != null) {
            try {
                this.close();
            }
            catch (Exception e) {
                log.error("fail closing activemq ", (Throwable)e);
                this.jmsTemplate = null;
            }
        }
        this.jmsTemplate = this.reconnect();
    }

    public JmsTemplate reconnect() {
        return this.activeMQSenderConfig.jmsTemplate();
    }

    public void send(String message) {
        this.send(this.defaultDestination, message);
    }

    public void close() {
        SingleConnectionFactory scf = (SingleConnectionFactory)this.jmsTemplate.getConnectionFactory();
        scf.destroy();
    }
}

