/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tas.sender.model.push;

import java.util.HashMap;
import java.util.Map;

public enum Platform {
    ANDROID("A"),
    iOS("I"),
    CHROME("C"),
    SAFARI("S"),
    FIREFOX("F"),
    UNKNOWN("U");

    final String code;
    private static Map<String, Platform> map;

    private Platform(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public static Platform getPlatform(String code) {
        return map.get(code);
    }

    public static Platform findByCode(String code) {
        for (Platform platform : Platform.values()) {
            if (!platform.getCode().equals(code)) continue;
            return platform;
        }
        return null;
    }

    static {
        map = new HashMap<String, Platform>();
        for (Platform platform : Platform.values()) {
            map.put(platform.getCode(), platform);
        }
    }
}

