/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tas.sender.client;

import java.util.Collections;
import java.util.Properties;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConnectionFactory {
    private static final Logger log = LoggerFactory.getLogger(KafkaConnectionFactory.class);
    private static Object key = new Object();
    private static volatile Producer<String, String> producer;

    private static Properties getKafkaProperties() {
        Properties props = new Properties();
        props.put("bootstrap.servers", "119.207.76.29:9092,119.207.76.30:9092,119.207.76.31:9092");
        props.put("client.id", "pushpiaKafkaProducer");
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("acks", "all");
        props.put("linger.ms", (Object)100);
        props.put("batch.size", (Object)65536);
        props.put("compression.type", "snappy");
        KafkaConnectionFactory.setupRetriesInFlightTimeout(props);
        return props;
    }

    private static Producer<String, String> createProducer() {
        if (producer == null) {
            try {
                Properties props = KafkaConnectionFactory.getKafkaProperties();
                producer = new KafkaProducer(props);
            }
            catch (Exception e) {
                log.error("Kafka producer config error", (Throwable)e);
            }
        }
        return producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Producer<String, String> getProducer() {
        if (producer == null) {
            Object object = key;
            synchronized (object) {
                if (producer == null) {
                    producer = KafkaConnectionFactory.createProducer();
                }
            }
        }
        return producer;
    }

    public static Consumer<String, String> createConsumer(String topic, String groupId) {
        Properties props = KafkaConnectionFactory.getKafkaProperties();
        props.put("group.id", groupId);
        props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        props.put("max.poll.records", "500");
        props.put("enable.auto.commit", "false");
        KafkaConsumer consumer = new KafkaConsumer(props);
        consumer.subscribe(Collections.singletonList(topic));
        return consumer;
    }

    private static void setupRetriesInFlightTimeout(Properties props) {
        props.put("max.in.flight.requests.per.connection", (Object)1);
        props.put("retries", (Object)3);
    }
}

