/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tas.sender.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.humuson.tas.sender.client.KafkaConnectionFactory;
import com.humuson.tas.sender.client.KafkaService;
import com.humuson.tas.sender.model.push.AppPushPayload;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppPushSendService
implements KafkaService<AppPushPayload> {
    private static final Logger log = LoggerFactory.getLogger(AppPushSendService.class);
    private static final String DEV_APPPUSH_TOPIC = "dev-app-push-request";
    private static final String PROD_APPPUSH_TOPIC = "prod-app-push-request";
    private static final long DEFAULT_TIMEOUT_MILLISECONDS = 5000L;
    private Producer<String, String> pushProducer;
    private ObjectMapper mapper;

    @Override
    public void init() {
        this.pushProducer = KafkaConnectionFactory.getProducer();
        this.mapper = new ObjectMapper();
    }

    @Override
    public void send(AppPushPayload payload) throws JsonProcessingException {
        this.send(payload, true);
    }

    @Override
    public void send(AppPushPayload payload, boolean isProduct) throws JsonProcessingException {
        String data = this.mapper.writeValueAsString((Object)payload);
        String topic = isProduct ? PROD_APPPUSH_TOPIC : DEV_APPPUSH_TOPIC;
        this.send(topic, data);
    }

    @Override
    public void send(String topic, AppPushPayload payload) throws JsonProcessingException {
        String data = this.mapper.writeValueAsString((Object)payload);
        this.send(topic, data);
    }

    @Override
    public void send(String topic, final String data) {
        this.pushProducer.send(new ProducerRecord(topic, (Object)data), new Callback(){

            public void onCompletion(RecordMetadata metadata, Exception exception) {
                if (exception != null) {
                    log.error("send error : {}", (Object)data);
                }
            }
        });
    }

    @Override
    public boolean sendSync(AppPushPayload payload) throws Exception {
        return this.sendSync(payload, true);
    }

    @Override
    public boolean sendSync(AppPushPayload payload, boolean isProduct) throws Exception {
        return this.sendSync(payload, isProduct, 5000L);
    }

    @Override
    public boolean sendSync(String topic, AppPushPayload payload) throws Exception {
        return this.sendSync(topic, payload, 5000L);
    }

    @Override
    public boolean sendSync(AppPushPayload payload, boolean isProduct, long timeout) throws Exception {
        String topic = isProduct ? PROD_APPPUSH_TOPIC : DEV_APPPUSH_TOPIC;
        return this.sendSync(topic, payload, timeout);
    }

    @Override
    public boolean sendSync(String topic, AppPushPayload payload, long timeout) throws Exception {
        try {
            String data = this.mapper.writeValueAsString((Object)payload);
            RecordMetadata recodeMetadata = (RecordMetadata)this.pushProducer.send(new ProducerRecord(topic, (Object)data)).get(5000L, TimeUnit.MILLISECONDS);
            if (log.isDebugEnabled()) {
                log.debug("topic:{}, partition:{}, checksum:{}", new Object[]{recodeMetadata.topic(), recodeMetadata.partition(), recodeMetadata.checksum()});
            }
            return true;
        }
        catch (Exception e) {
            log.error("send kafka error", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void close() {
        if (this.pushProducer != null) {
            try {
                this.pushProducer.close();
            }
            catch (Exception e) {
                log.error("kafka producer close error", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String jsonAndroid = "{\"grpId\":403,\"CUST_ID\":\"tt\",\"DEVICE\":{\"ID\":2849292,\"APP_ID\":302,\"TOKEN\":\"f3nR1Op6mMk:APA91bEQIyjxsOc4WUG7G1RqiX5SHi8e6z2lXeeKluC39xRusBbNwAmm70AEATZcZTdk6EBWex30GY5BZ9Y6-NFXjaEE_B42OJd77hrVw_c1T7OWQS9zZOM4d0qEHb1NtG8ZxZ7ziYax\",\"NOTI_FLAG\":\"Y\",\"PLATFORM\":\"ANDROID\"},\"APP_GRP_KEY\":\"483f102fe98e462ebd1e\",\"TITLE\":\"TITLE11112\",\"MESSAGE\":\"MESSAGE111112\",\"PUSH_KEY\":\"l\",\"PUSH_VALUE\":\"\",\"TTL\":0,\"REQUEST_UID\":\"rearere:$%#^&*(\",\"REPORT_QUEUE\":\"local-app-push-report\",\"MSG_ID\":\"117481\",\"MSG_TYPE\":\"T\"}";
        String jsonIos = "{\"grpId\":403,\"CUST_ID\":\"chs\",\"DEVICE\":{\"ID\":2746918,\"APP_ID\":303,\"TOKEN\":\"689fe9cdfee2e63c730364cff7feb7a033c87ecd0f4865787dc4d6ed3ad4844f\",\"NOTI_FLAG\":\"Y\",\"PLATFORM\":\"iOS\"},\"APP_GRP_KEY\":\"483f102fe98e462ebd1e\",\"TITLE\":\"TITLE11112\",\"MESSAGE\":\"MESSAGE111112\",\"INAPP_CONTENT\":\"INAPP_MESSAGE\",\"PUSH_KEY\":\"l\",\"PUSH_VALUE\":\"\",\"TTL\":0,\"REQUEST_UID\":\"rearere:$%#^&*(\",\"REPORT_QUEUE\":\"local-app-push-report\",\"MSG_ID\":\"117481\",\"MSG_TYPE\":\"T\"}";
        AppPushSendService s = new AppPushSendService();
        s.init();
        ObjectMapper mapper = new ObjectMapper();
        try {
            for (int i = 0; i < 2; ++i) {
                AppPushPayload payload = (AppPushPayload)mapper.readValue(jsonIos, AppPushPayload.class);
                payload.setMsgId(System.currentTimeMillis() + (long)i + "");
                payload.setTitle(payload.getTitle() + i);
                payload.setRequestUid(System.currentTimeMillis() + "" + i);
                System.out.println("payload :" + mapper.writeValueAsString((Object)payload));
                s.send("local-app-push-request", payload);
            }
            Thread.sleep(10000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
    }
}

