/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tas.sender.model.push;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.humuson.tas.sender.constant.PushResponse;
import com.humuson.tas.sender.constant.ReportType;
import java.io.Serializable;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PushReport
implements Serializable {
    private static final long serialVersionUID = 8359839836953909232L;
    private ReportType reportType;
    @JsonProperty(value="CUST_ID")
    private String custId;
    @JsonProperty(value="UUID")
    private String uuid;
    private PushResponse pushResponse;
    @JsonProperty(value="RESULT_CD")
    private String resultCd;
    @JsonProperty(value="REPORT_QUEUE")
    private String reportQueue = "";
    @JsonProperty(value="REQUEST_UID")
    private String requestUid;
    @JsonProperty(value="USER_DATA")
    private Map<String, Object> userData;
    @JsonProperty(value="RESPONSE_DATE")
    private String responseDate;

    @JsonProperty(value="REPORT_TYPE")
    public String getReportType() {
        return this.reportType.getCode();
    }

    public void setPushResponse(PushResponse pushResponse) {
        this.pushResponse = pushResponse;
        this.resultCd = pushResponse.getStatusCode();
    }

    public void setReportType(String reportType) {
        this.reportType = ReportType.findByCode(reportType);
    }

    public PushReport(ReportType reportType, String custId, String requestUid, String reportQueue, Map<String, Object> userData, PushResponse response) {
        this(reportType, custId, null, requestUid, reportQueue, userData, response);
    }

    public PushReport(ReportType reportType, String custId, String uuid, String requestUid, String reportQueue, Map<String, Object> userData, PushResponse response) {
        this.reportType = reportType;
        this.custId = custId;
        this.uuid = uuid;
        this.requestUid = requestUid;
        this.reportQueue = !"".equals(reportQueue) ? reportQueue : "";
        this.pushResponse = response;
        this.resultCd = this.pushResponse.getStatusCode();
        this.userData = userData;
        this.responseDate = System.currentTimeMillis() + "";
    }

    public PushReport() {
    }

    public String getCustId() {
        return this.custId;
    }

    public String getUuid() {
        return this.uuid;
    }

    public PushResponse getPushResponse() {
        return this.pushResponse;
    }

    public String getResultCd() {
        return this.resultCd;
    }

    public String getReportQueue() {
        return this.reportQueue;
    }

    public String getRequestUid() {
        return this.requestUid;
    }

    public Map<String, Object> getUserData() {
        return this.userData;
    }

    public String getResponseDate() {
        return this.responseDate;
    }

    public void setCustId(String custId) {
        this.custId = custId;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setResultCd(String resultCd) {
        this.resultCd = resultCd;
    }

    public void setReportQueue(String reportQueue) {
        this.reportQueue = reportQueue;
    }

    public void setRequestUid(String requestUid) {
        this.requestUid = requestUid;
    }

    public void setUserData(Map<String, Object> userData) {
        this.userData = userData;
    }

    public void setResponseDate(String responseDate) {
        this.responseDate = responseDate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PushReport)) {
            return false;
        }
        PushReport other = (PushReport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$reportType = this.getReportType();
        String other$reportType = other.getReportType();
        if (this$reportType == null ? other$reportType != null : !this$reportType.equals(other$reportType)) {
            return false;
        }
        String this$custId = this.getCustId();
        String other$custId = other.getCustId();
        if (this$custId == null ? other$custId != null : !this$custId.equals(other$custId)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        PushResponse this$pushResponse = this.getPushResponse();
        PushResponse other$pushResponse = other.getPushResponse();
        if (this$pushResponse == null ? other$pushResponse != null : !((Object)((Object)this$pushResponse)).equals((Object)other$pushResponse)) {
            return false;
        }
        String this$resultCd = this.getResultCd();
        String other$resultCd = other.getResultCd();
        if (this$resultCd == null ? other$resultCd != null : !this$resultCd.equals(other$resultCd)) {
            return false;
        }
        String this$reportQueue = this.getReportQueue();
        String other$reportQueue = other.getReportQueue();
        if (this$reportQueue == null ? other$reportQueue != null : !this$reportQueue.equals(other$reportQueue)) {
            return false;
        }
        String this$requestUid = this.getRequestUid();
        String other$requestUid = other.getRequestUid();
        if (this$requestUid == null ? other$requestUid != null : !this$requestUid.equals(other$requestUid)) {
            return false;
        }
        Map<String, Object> this$userData = this.getUserData();
        Map<String, Object> other$userData = other.getUserData();
        if (this$userData == null ? other$userData != null : !((Object)this$userData).equals(other$userData)) {
            return false;
        }
        String this$responseDate = this.getResponseDate();
        String other$responseDate = other.getResponseDate();
        return !(this$responseDate == null ? other$responseDate != null : !this$responseDate.equals(other$responseDate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PushReport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $reportType = this.getReportType();
        result = result * 59 + ($reportType == null ? 43 : $reportType.hashCode());
        String $custId = this.getCustId();
        result = result * 59 + ($custId == null ? 43 : $custId.hashCode());
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        PushResponse $pushResponse = this.getPushResponse();
        result = result * 59 + ($pushResponse == null ? 43 : ((Object)((Object)$pushResponse)).hashCode());
        String $resultCd = this.getResultCd();
        result = result * 59 + ($resultCd == null ? 43 : $resultCd.hashCode());
        String $reportQueue = this.getReportQueue();
        result = result * 59 + ($reportQueue == null ? 43 : $reportQueue.hashCode());
        String $requestUid = this.getRequestUid();
        result = result * 59 + ($requestUid == null ? 43 : $requestUid.hashCode());
        Map<String, Object> $userData = this.getUserData();
        result = result * 59 + ($userData == null ? 43 : ((Object)$userData).hashCode());
        String $responseDate = this.getResponseDate();
        result = result * 59 + ($responseDate == null ? 43 : $responseDate.hashCode());
        return result;
    }

    public String toString() {
        return "PushReport(reportType=" + this.getReportType() + ", custId=" + this.getCustId() + ", uuid=" + this.getUuid() + ", pushResponse=" + (Object)((Object)this.getPushResponse()) + ", resultCd=" + this.getResultCd() + ", reportQueue=" + this.getReportQueue() + ", requestUid=" + this.getRequestUid() + ", userData=" + this.getUserData() + ", responseDate=" + this.getResponseDate() + ")";
    }
}

