package com.humuson.tas.sender.model.push;

import java.util.HashMap;
import java.util.Map;

public enum Platform {
	
	ANDROID("A"),
	iOS("I"),
	CHROME("C"),
	SAFARI("S"),
	FIREFOX("F");
	
	final String code;
	
	private static Map<String, Platform> map = new HashMap<String, Platform>();
	
	Platform(String code) {
		this.code = code;
	}
	
	public String getCode() {
		return code;
	}
	
	static {
        for (Platform platform : Platform.values()) {
            map.put(platform.getCode(), platform);
        }
    }
	
	public static Platform getPlatform(String code) {
        return (Platform) map.get(code);
    }
}
