/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tas.sender.constant;

import com.humuson.tas.sender.constant.HttpStatus;

public enum Status {
    OK("000", "OK", HttpStatus.OK),
    AuthenticationFail("E011", "Authentication fail", HttpStatus.UNAUTHORIZED),
    ApiKeyIsNotValid("E012", "Api Key is not valid", HttpStatus.UNAUTHORIZED),
    UserAlreadyExist("E013", "user already exist", HttpStatus.UNAUTHORIZED),
    InvalidToken("E014", "Invalid Token", HttpStatus.UNAUTHORIZED),
    UserNotFound("E015", "user not found", HttpStatus.UNAUTHORIZED),
    UrlNotFound("E021", "URL not found", HttpStatus.NOT_FOUND),
    ParamNotValid("E031", "param not valid", HttpStatus.BAD_REQUEST),
    NoRegisteredValue("E041", "no registered value", HttpStatus.BAD_REQUEST),
    NoSuchTypes("E042", "no such types", HttpStatus.BAD_REQUEST),
    ContentTypeError("E051", "content type error", HttpStatus.BAD_REQUEST),
    JsonParseError("E061", "json parse error", HttpStatus.BAD_REQUEST),
    NotReadableRequest("E071", "not readable request", HttpStatus.BAD_REQUEST),
    RequestMethodNotSupported("E081", "request method not supported", HttpStatus.METHOD_NOT_ALLOWED),
    AccessDenied("E091", "access denied", HttpStatus.FORBIDDEN),
    AppNotRegistered("E101", "App Not Registered", HttpStatus.BAD_REQUEST),
    SiteNotRegistered("E102", "Site Not Registered", HttpStatus.BAD_REQUEST),
    AudienceUserUploadError("E201", "audience upload error", HttpStatus.INTERNAL_SERVER_ERROR),
    PostmanApiError("E301", "poatman api error", HttpStatus.INTERNAL_SERVER_ERROR),
    PushpiaApiError("E301", "pushpia api error", HttpStatus.INTERNAL_SERVER_ERROR),
    EncryptError("E401", "encrypt error", HttpStatus.INTERNAL_SERVER_ERROR),
    DecryptError("E402", "decrypt error", HttpStatus.INTERNAL_SERVER_ERROR),
    AlreadyExist("E901", "already exist", HttpStatus.BAD_REQUEST),
    ServerError("E999", "server error", HttpStatus.INTERNAL_SERVER_ERROR);

    private String statusCode;
    private String reasonPhrase;
    private HttpStatus httpStatus;

    private Status(String statusCode, String reasonPhrase, HttpStatus httpStatus) {
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
        this.httpStatus = httpStatus;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    public static Status findStatusByCode(String statusCode) {
        for (Status error : Status.values()) {
            if (!error.getStatusCode().equals(statusCode)) continue;
            return error;
        }
        return null;
    }

    public static HttpStatus findHttpStatusByCode(String errCode) {
        HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
        for (Status error : Status.values()) {
            if (!error.getStatusCode().equals(errCode)) continue;
            status = error.getHttpStatus();
            break;
        }
        return status;
    }
}

